/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Model definition for DatasetAccessEntry.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DatasetAccessEntry extends com.google.api.client.json.GenericJson {

  /**
   * [Required] The dataset this entry applies to.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DatasetReference dataset;

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> targetTypes;

  /**
   * [Required] The dataset this entry applies to.
   * @return value or {@code null} for none
   */
  public DatasetReference getDataset() {
    return dataset;
  }

  /**
   * [Required] The dataset this entry applies to.
   * @param dataset dataset or {@code null} for none
   */
  public DatasetAccessEntry setDataset(DatasetReference dataset) {
    this.dataset = dataset;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getTargetTypes() {
    return targetTypes;
  }

  /**
   * @param targetTypes targetTypes or {@code null} for none
   */
  public DatasetAccessEntry setTargetTypes(java.util.List<java.lang.String> targetTypes) {
    this.targetTypes = targetTypes;
    return this;
  }

  @Override
  public DatasetAccessEntry set(String fieldName, Object value) {
    return (DatasetAccessEntry) super.set(fieldName, value);
  }

  @Override
  public DatasetAccessEntry clone() {
    return (DatasetAccessEntry) super.clone();
  }

}
