/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.modules;

import com.google.appengine.api.modules.ModulesException;
import com.google.appengine.api.modules.ModulesService;
import com.google.appengine.api.modules.ModulesServicePb;
import com.google.appengine.api.modules.UnexpectedStateException;
import com.google.appengine.api.utils.FutureWrapper;
import com.google.appengine.repackaged.com.google.common.base.Splitter;
import com.google.appengine.repackaged.com.google.common.collect.Sets;
import com.google.appengine.repackaged.com.google.common.util.concurrent.ForwardingFuture;
import com.google.appengine.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.appengine.repackaged.com.google.protobuf.Message;
import com.google.apphosting.api.ApiProxy;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;

class ModulesServiceImpl
implements ModulesService {
    private static final Logger logger = Logger.getLogger(ModulesServiceImpl.class.getName());
    private static final String STARTING_STARTED_MESSAGE = "Attempted to start an already started module version, continuing";
    private static final String STOPPING_STOPPED_MESSAGE = "Attempted to stop an already stopped module version, continuing";
    static final String PACKAGE = "modules";
    private static final String INSTANCE_ID_ENV_ATTRIBUTE = "com.google.appengine.instance.id";

    @Override
    public String getCurrentModule() {
        return ModulesServiceImpl.getCurrentEnvironmentOrThrow().getModuleId();
    }

    @Override
    public String getCurrentVersion() {
        ApiProxy.Environment env = ModulesServiceImpl.getCurrentEnvironmentOrThrow();
        return Splitter.on('.').split(env.getVersionId()).iterator().next();
    }

    private static Map<String, Object> getThreadLocalAttributes() {
        return ModulesServiceImpl.getCurrentEnvironmentOrThrow().getAttributes();
    }

    @Override
    public String getCurrentInstanceId() {
        Map<String, Object> env = ModulesServiceImpl.getThreadLocalAttributes();
        if (!env.containsKey(INSTANCE_ID_ENV_ATTRIBUTE)) {
            throw new ModulesException("Instance id unavailable");
        }
        String instanceId = (String)ModulesServiceImpl.getThreadLocalAttributes().get(INSTANCE_ID_ENV_ATTRIBUTE);
        if (instanceId == null) {
            throw new ModulesException("Instance id unavailable");
        }
        return instanceId;
    }

    private <V> V getAsyncResult(Future<V> asyncResult) {
        try {
            return asyncResult.get();
        }
        catch (InterruptedException ie) {
            throw new ModulesException("Unexpected failure", ie);
        }
        catch (ExecutionException ee) {
            if (ee.getCause() instanceof RuntimeException) {
                throw (RuntimeException)ee.getCause();
            }
            if (ee.getCause() instanceof Error) {
                throw (Error)ee.getCause();
            }
            throw new UndeclaredThrowableException(ee.getCause());
        }
    }

    @Override
    public Set<String> getModules() {
        return this.getAsyncResult(this.getModulesAsync());
    }

    private Future<Set<String>> getModulesAsync() {
        ModulesServicePb.GetModulesRequest.Builder requestBuilder = ModulesServicePb.GetModulesRequest.newBuilder();
        ModulesServiceFutureWrapper<Set<String>> result = new ModulesServiceFutureWrapper<Set<String>>(this, "GetModules", (Message.Builder)requestBuilder){

            @Override
            protected Set<String> wrap(byte[] key) throws InvalidProtocolBufferException {
                ModulesServicePb.GetModulesResponse.Builder responseBuilder = ModulesServicePb.GetModulesResponse.newBuilder();
                responseBuilder.mergeFrom(key);
                return Sets.newHashSet(responseBuilder.getModuleList());
            }
        };
        return result;
    }

    @Override
    public Set<String> getVersions(String module) {
        return this.getAsyncResult(this.getVersionsAsync(module));
    }

    private Future<Set<String>> getVersionsAsync(String module) {
        ModulesServicePb.GetVersionsRequest.Builder requestBuilder = ModulesServicePb.GetVersionsRequest.newBuilder();
        if (module != null) {
            requestBuilder.setModule(module);
        }
        ModulesServiceFutureWrapper<Set<String>> result = new ModulesServiceFutureWrapper<Set<String>>(this, "GetVersions", (Message.Builder)requestBuilder){

            @Override
            protected Set<String> wrap(byte[] key) throws InvalidProtocolBufferException {
                ModulesServicePb.GetVersionsResponse.Builder responseBuilder = ModulesServicePb.GetVersionsResponse.newBuilder();
                responseBuilder.mergeFrom(key);
                return Sets.newHashSet(responseBuilder.getVersionList());
            }
        };
        return result;
    }

    @Override
    public String getDefaultVersion(String module) {
        return this.getAsyncResult(this.getDefaultVersionAsync(module));
    }

    private Future<String> getDefaultVersionAsync(String module) {
        ModulesServicePb.GetDefaultVersionRequest.Builder requestBuilder = ModulesServicePb.GetDefaultVersionRequest.newBuilder();
        if (module != null) {
            requestBuilder.setModule(module);
        }
        ModulesServiceFutureWrapper<String> result = new ModulesServiceFutureWrapper<String>(this, "GetDefaultVersion", (Message.Builder)requestBuilder){

            @Override
            protected String wrap(byte[] key) throws InvalidProtocolBufferException {
                ModulesServicePb.GetDefaultVersionResponse.Builder responseBuilder = ModulesServicePb.GetDefaultVersionResponse.newBuilder();
                responseBuilder.mergeFrom(key);
                return responseBuilder.getVersion();
            }
        };
        return result;
    }

    @Override
    public int getNumInstances(String module, String version) {
        return this.getAsyncResult(this.getNumInstancesAsync(module, version));
    }

    private Future<Integer> getNumInstancesAsync(String module, String version) {
        ModulesServicePb.GetNumInstancesRequest.Builder requestBuilder = ModulesServicePb.GetNumInstancesRequest.newBuilder();
        if (module != null) {
            requestBuilder.setModule(module);
        }
        if (version != null) {
            requestBuilder.setVersion(version);
        }
        ModulesServiceFutureWrapper<Integer> result = new ModulesServiceFutureWrapper<Integer>(this, "GetNumInstances", (Message.Builder)requestBuilder){

            @Override
            protected Integer wrap(byte[] key) throws InvalidProtocolBufferException {
                ModulesServicePb.GetNumInstancesResponse.Builder responseBuilder = ModulesServicePb.GetNumInstancesResponse.newBuilder();
                responseBuilder.mergeFrom(key);
                if (responseBuilder.getInstances() < 0L || responseBuilder.getInstances() > Integer.MAX_VALUE) {
                    long l = responseBuilder.getInstances();
                    throw new IllegalStateException(new StringBuilder(45).append("Invalid instances value: ").append(l).toString());
                }
                return (int)responseBuilder.getInstances();
            }
        };
        return result;
    }

    @Override
    public void setNumInstances(String module, String version, long instances) {
        this.getAsyncResult(this.setNumInstancesAsync(module, version, instances));
    }

    @Override
    public Future<Void> setNumInstancesAsync(String module, String version, long instances) {
        ModulesServicePb.SetNumInstancesRequest.Builder requestBuilder = ModulesServicePb.SetNumInstancesRequest.newBuilder();
        if (module != null) {
            requestBuilder.setModule(module);
        }
        if (version != null) {
            requestBuilder.setVersion(version);
        }
        requestBuilder.setInstances(instances);
        ModulesServiceFutureWrapper<Void> result = new ModulesServiceFutureWrapper<Void>(this, "SetNumInstances", (Message.Builder)requestBuilder){

            @Override
            protected Void wrap(byte[] key) throws InvalidProtocolBufferException {
                ModulesServicePb.SetNumInstancesResponse.Builder responseBuilder = ModulesServicePb.SetNumInstancesResponse.newBuilder();
                responseBuilder.mergeFrom(key);
                return null;
            }
        };
        return result;
    }

    @Override
    public void startVersion(String module, String version) {
        this.getAsyncResult(this.startVersionAsync(module, version));
    }

    @Override
    public Future<Void> startVersionAsync(String module, String version) {
        ModulesServicePb.StartModuleRequest.Builder requestBuilder = ModulesServicePb.StartModuleRequest.newBuilder();
        requestBuilder.setModule(module);
        requestBuilder.setVersion(version);
        ModulesServiceFutureWrapper<Void> modulesServiceFuture = new ModulesServiceFutureWrapper<Void>(this, "StartModule", (Message.Builder)requestBuilder){

            @Override
            protected Void wrap(byte[] key) throws InvalidProtocolBufferException {
                ModulesServicePb.StartModuleResponse.Builder responseBuilder = ModulesServicePb.StartModuleResponse.newBuilder();
                responseBuilder.mergeFrom(key);
                return null;
            }
        };
        return new IgnoreUnexpectedStateExceptionFuture((Future<Void>)modulesServiceFuture, STARTING_STARTED_MESSAGE);
    }

    @Override
    public void stopVersion(String module, String version) {
        this.getAsyncResult(this.stopVersionAsync(module, version));
    }

    @Override
    public Future<Void> stopVersionAsync(String module, String version) {
        ModulesServicePb.StopModuleRequest.Builder requestBuilder = ModulesServicePb.StopModuleRequest.newBuilder();
        if (module != null) {
            requestBuilder.setModule(module);
        }
        if (version != null) {
            requestBuilder.setVersion(version);
        }
        ModulesServiceFutureWrapper<Void> modulesServiceFuture = new ModulesServiceFutureWrapper<Void>(this, "StopModule", (Message.Builder)requestBuilder){

            @Override
            protected Void wrap(byte[] key) throws InvalidProtocolBufferException {
                ModulesServicePb.StopModuleResponse.Builder responseBuilder = ModulesServicePb.StopModuleResponse.newBuilder();
                responseBuilder.mergeFrom(key);
                return null;
            }
        };
        return new IgnoreUnexpectedStateExceptionFuture((Future<Void>)modulesServiceFuture, STOPPING_STOPPED_MESSAGE);
    }

    private Future<String> getHostnameAsync(ModulesServicePb.GetHostnameRequest.Builder requestBuilder) {
        ModulesServiceFutureWrapper<String> result = new ModulesServiceFutureWrapper<String>(this, "GetHostname", (Message.Builder)requestBuilder){

            @Override
            protected String wrap(byte[] key) throws InvalidProtocolBufferException {
                ModulesServicePb.GetHostnameResponse.Builder responseBuilder = ModulesServicePb.GetHostnameResponse.newBuilder();
                responseBuilder.mergeFrom(key);
                return responseBuilder.getHostname();
            }
        };
        return result;
    }

    private ModulesServicePb.GetHostnameRequest.Builder newGetHostnameRequestBuilder(String module, String version) {
        ModulesServicePb.GetHostnameRequest.Builder builder = ModulesServicePb.GetHostnameRequest.newBuilder();
        if (module != null) {
            builder.setModule(module);
        }
        if (version != null) {
            builder.setVersion(version);
        }
        return builder;
    }

    @Override
    public String getVersionHostname(String module, String version) {
        return this.getAsyncResult(this.getVersionHostnameAsync(module, version));
    }

    private Future<String> getVersionHostnameAsync(String module, String version) {
        ModulesServicePb.GetHostnameRequest.Builder requestBuilder = this.newGetHostnameRequestBuilder(module, version);
        return this.getHostnameAsync(requestBuilder);
    }

    @Override
    public String getInstanceHostname(String module, String version, String instance) {
        return this.getAsyncResult(this.getInstanceHostnameAsync(module, version, instance));
    }

    private Future<String> getInstanceHostnameAsync(String module, String version, String instance) {
        ModulesServicePb.GetHostnameRequest.Builder requestBuilder = this.newGetHostnameRequestBuilder(module, version);
        requestBuilder.setInstance(instance);
        return this.getHostnameAsync(requestBuilder);
    }

    ModulesServiceImpl() {
    }

    private static ApiProxy.Environment getCurrentEnvironmentOrThrow() {
        ApiProxy.Environment environment = ApiProxy.getCurrentEnvironment();
        if (environment == null) {
            throw new IllegalStateException("Operation not allowed in a thread that is neither the original request thread nor a thread created by ThreadManager");
        }
        return environment;
    }

    private static class IgnoreUnexpectedStateExceptionFuture
    extends ForwardingFuture<Void> {
        private final Future<Void> delegate;
        private final String logMessage;

        IgnoreUnexpectedStateExceptionFuture(Future<Void> delegate, String logMessage) {
            this.delegate = delegate;
            this.logMessage = logMessage;
        }

        @Override
        protected Future<Void> delegate() {
            return this.delegate;
        }

        @Override
        public Void get() throws InterruptedException, ExecutionException {
            try {
                return this.delegate.get();
            }
            catch (ExecutionException ee) {
                return this.throwOriginalUnlessUnexpectedState(ee);
            }
        }

        @Override
        public Void get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            try {
                return this.delegate.get(timeout, unit);
            }
            catch (ExecutionException ee) {
                return this.throwOriginalUnlessUnexpectedState(ee);
            }
        }

        private Void throwOriginalUnlessUnexpectedState(ExecutionException original) throws ExecutionException {
            Throwable cause = original.getCause();
            if (cause instanceof UnexpectedStateException) {
                logger.info(this.logMessage);
                return null;
            }
            throw original;
        }
    }

    private static abstract class ModulesServiceFutureWrapper<V>
    extends FutureWrapper<byte[], V> {
        private final String method;

        public ModulesServiceFutureWrapper(String method, Message.Builder request) {
            super(ApiProxy.makeAsyncCall(ModulesServiceImpl.PACKAGE, method, request.build().toByteArray()));
            this.method = method;
        }

        @Override
        protected Throwable convertException(Throwable cause) {
            if (cause instanceof ApiProxy.ApplicationException) {
                return this.convertApplicationException(this.method, (ApiProxy.ApplicationException)cause);
            }
            if (cause instanceof InvalidProtocolBufferException) {
                return new ModulesException("Unexpected failure", cause);
            }
            return cause;
        }

        private RuntimeException convertApplicationException(String method, ApiProxy.ApplicationException e) {
            switch (ModulesServicePb.ModulesServiceError.ErrorCode.forNumber(e.getApplicationError())) {
                case INVALID_MODULE: {
                    ModulesException result1 = new ModulesException("Unknown module");
                    return result1;
                }
                case INVALID_VERSION: {
                    ModulesException result2 = new ModulesException("Unknown module version");
                    return result2;
                }
                case INVALID_INSTANCES: {
                    ModulesException result3 = new ModulesException("Invalid instance");
                    return result3;
                }
                case UNEXPECTED_STATE: {
                    if (method.equals("StartModule") || method.equals("StopModule")) {
                        String string = String.valueOf(method);
                        return new UnexpectedStateException(string.length() != 0 ? "Unexpected state for method ".concat(string) : new String("Unexpected state for method "));
                    }
                    return new ModulesException(new StringBuilder(31 + String.valueOf(method).length()).append("Unexpected state with method '").append(method).append("'").toString());
                }
            }
            int n = e.getApplicationError();
            return new ModulesException(new StringBuilder(28).append("Unknown error: '").append(n).append("'").toString());
        }
    }
}

