/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.socket;

import com.google.appengine.api.socket.SocketApiHelper;
import com.google.appengine.api.socket.SocketServicePb;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

class NameServiceImpl {
    private static final byte[] LOCAL_HOST_ADDR = new byte[]{127, 0, 0, 1};
    private static final String LOCAL_HOST = "localhost";
    private final SocketApiHelper socketHelper;

    static Object create(SocketApiHelper socketHelper) {
        Class<?> nameServiceInterface;
        try {
            nameServiceInterface = Class.forName("sun.net.spi.nameservice.NameService", false, null);
        }
        catch (ClassNotFoundException e) {
            throw new UnsupportedOperationException(e);
        }
        NameServiceImpl nameServiceImpl = new NameServiceImpl(socketHelper);
        Handler handler = new Handler(nameServiceImpl);
        return Proxy.newProxyInstance(null, new Class[]{nameServiceInterface}, (InvocationHandler)handler);
    }

    NameServiceImpl(SocketApiHelper socketHelper) {
        if (socketHelper == null) {
            throw new IllegalArgumentException("socketHelper must not be null.");
        }
        this.socketHelper = socketHelper;
    }

    SocketApiHelper getSocketApiHelper() {
        return this.socketHelper;
    }

    public InetAddress[] lookupAllHostAddr(String host) throws UnknownHostException {
        if (host.equals(LOCAL_HOST)) {
            InetAddress[] result = new InetAddress[]{InetAddress.getByAddress(host, LOCAL_HOST_ADDR)};
            return result;
        }
        SocketServicePb.ResolveRequest request = new SocketServicePb.ResolveRequest().setName(host);
        request.mutableAddressFamiliess().addAll(Arrays.asList(SocketServicePb.CreateSocketRequest.SocketFamily.IPv4.getValue(), SocketServicePb.CreateSocketRequest.SocketFamily.IPv6.getValue()));
        SocketServicePb.ResolveReply response = new SocketServicePb.ResolveReply();
        try {
            SocketServicePb.RemoteSocketServiceError serviceError = new SocketServicePb.RemoteSocketServiceError();
            if (!this.socketHelper.makeSyncCall("Resolve", request, response, serviceError)) {
                SocketServicePb.ResolveReply.ErrorCode errorCode = SocketServicePb.ResolveReply.ErrorCode.valueOf(serviceError.getSystemError());
                if (errorCode == null) {
                    String string = serviceError.toFlatString();
                    throw new RuntimeException(new StringBuilder(24 + String.valueOf(host).length() + String.valueOf(string).length()).append("Resolve failed: host:'").append(host).append("' ").append(string).toString());
                }
                switch (SocketServicePb.ResolveReply.ErrorCode.valueOf(serviceError.getSystemError())) {
                    case SOCKET_EAI_NONAME: 
                    case SOCKET_EAI_AGAIN: {
                        throw new UnknownHostException(host);
                    }
                }
                String string = serviceError.toFlatString();
                throw new RuntimeException(new StringBuilder(24 + String.valueOf(host).length() + String.valueOf(string).length()).append("Resolve failed: host:'").append(host).append("' ").append(string).toString());
            }
        }
        catch (SocketException e) {
            String errorCode = String.valueOf(e);
            throw new RuntimeException(new StringBuilder(35 + String.valueOf(host).length() + String.valueOf(errorCode).length()).append("Resolve failed: Request=").append(host).append(" Exception=").append(errorCode).toString());
        }
        if (response.packedAddresssAsBytes().isEmpty()) {
            throw new UnknownHostException(host);
        }
        List<byte[]> addresses = response.packedAddresssAsBytes();
        InetAddress[] result = new InetAddress[addresses.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = InetAddress.getByAddress(host, addresses.get(i));
        }
        return result;
    }

    public String getHostByAddr(byte[] addr) throws UnknownHostException {
        if (Arrays.equals(LOCAL_HOST_ADDR, addr)) {
            return LOCAL_HOST;
        }
        if (addr.length == 4) {
            return NameServiceImpl.getHostAddrForPackedAddr(addr);
        }
        if (addr.length == 16) {
            return NameServiceImpl.getHostAddrForPackedAddr(addr);
        }
        throw new UnknownHostException(NameServiceImpl.getHostAddrForPackedAddr(addr));
    }

    private static String getHostAddrForPackedAddr(byte[] addr) {
        StringBuilder builder = new StringBuilder();
        if (addr.length == 16) {
            String separator = "";
            for (int i = 0; i < 16; i += 2) {
                int val = ((addr[i] & 0xFF) << 8) + (addr[i + 1] & 0xFF);
                builder.append(separator);
                separator = ":";
                builder.append(Integer.toHexString(val));
            }
        } else {
            String separator = "";
            for (byte val : addr) {
                builder.append(separator);
                separator = ".";
                builder.append(val & 0xFF);
            }
        }
        return builder.toString();
    }

    private static class Handler
    implements InvocationHandler {
        private final NameServiceImpl impl;
        private final ConcurrentHashMap<Method, Method> intfToImpl = new ConcurrentHashMap();

        private Handler(NameServiceImpl impl) {
            this.impl = impl;
        }

        @Override
        public Object invoke(Object proxy, Method intfMethod, Object[] args) throws Throwable {
            Method implMethod = this.intfToImpl.get(intfMethod);
            if (implMethod == null) {
                implMethod = NameServiceImpl.class.getMethod(intfMethod.getName(), intfMethod.getParameterTypes());
                this.intfToImpl.put(intfMethod, implMethod);
            }
            try {
                return implMethod.invoke((Object)this.impl, args);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }
    }
}

