/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.protobuf.proto1api;

import com.google.appengine.repackaged.com.google.io.protocol.MessageAppender;
import com.google.appengine.repackaged.com.google.io.protocol.Proto2ParserAdapter;
import com.google.appengine.repackaged.com.google.io.protocol.Protocol;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolMessage;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolSink;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolSource;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolSupport;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolType;
import com.google.appengine.repackaged.com.google.io.protocol.UninterpretedTags;
import com.google.appengine.repackaged.com.google.protobuf.Descriptors;
import com.google.appengine.repackaged.com.google.protobuf.Internal;
import com.google.appengine.repackaged.com.google.protobuf.Parser;
import com.google.appengine.repackaged.com.google.protobuf.proto1api.ListValue;
import com.google.appengine.repackaged.com.google.protobuf.proto1api.Struct;
import java.nio.charset.Charset;
import java.util.Arrays;

public class Value
extends ProtocolMessage<Value> {
    private static final long serialVersionUID = 1L;
    private int null_value_ = 0;
    private double number_value_ = 0.0;
    private volatile Object string_value_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
    private boolean bool_value_ = false;
    private Struct struct_value_ = null;
    private ListValue list_value_ = null;
    private UninterpretedTags uninterpreted;
    private int optional_0_;
    public static final Value IMMUTABLE_DEFAULT_INSTANCE = new Value(){
        private static final long serialVersionUID = 1L;

        @Override
        public Value clearNullValue() {
            return this;
        }

        @Override
        public Value setNullValue(int x) {
            ProtocolSupport.unsupportedOperation();
            return this;
        }

        @Override
        public Value clearNumberValue() {
            return this;
        }

        @Override
        public Value setNumberValue(double x) {
            ProtocolSupport.unsupportedOperation();
            return this;
        }

        @Override
        public Value clearStringValue() {
            return this;
        }

        @Override
        public Value setStringValueAsBytes(byte[] x) {
            ProtocolSupport.unsupportedOperation();
            return this;
        }

        @Override
        public Value setStringValue(String v) {
            ProtocolSupport.unsupportedOperation();
            return this;
        }

        @Override
        public Value setStringValue(String v, Charset cs) {
            ProtocolSupport.unsupportedOperation();
            return this;
        }

        @Override
        public Value clearBoolValue() {
            return this;
        }

        @Override
        public Value setBoolValue(boolean x) {
            ProtocolSupport.unsupportedOperation();
            return this;
        }

        @Override
        public Value clearStructValue() {
            return this;
        }

        @Override
        public Value setStructValue(Struct x) {
            ProtocolSupport.unsupportedOperation();
            return this;
        }

        @Override
        public Struct getMutableStructValue() {
            return (Struct)ProtocolSupport.unsupportedOperation();
        }

        @Override
        public Value clearListValue() {
            return this;
        }

        @Override
        public Value setListValue(ListValue x) {
            ProtocolSupport.unsupportedOperation();
            return this;
        }

        @Override
        public ListValue getMutableListValue() {
            return (ListValue)ProtocolSupport.unsupportedOperation();
        }

        @Override
        public Value mergeFrom(Value that) {
            ProtocolSupport.unsupportedOperation();
            return this;
        }

        @Override
        public boolean merge(ProtocolSource source) {
            ProtocolSupport.unsupportedOperation();
            return false;
        }

        @Override
        public Value freeze() {
            return this;
        }

        @Override
        public Value unfreeze() {
            ProtocolSupport.unsupportedOperation();
            return this;
        }

        @Override
        public boolean isFrozen() {
            return true;
        }
    };
    private static final Parser<Value> PARSER = new Proto2ParserAdapter<Value>(Value.getDefaultInstance());
    public static final int knull_value = 1;
    public static final int knumber_value = 2;
    public static final int kstring_value = 3;
    public static final int kbool_value = 4;
    public static final int kstruct_value = 5;
    public static final int klist_value = 6;
    public static final String[] text = new String[7];
    public static final int[] types;
    public static final String style = "";
    public static final String style_content_type = "";

    public final int getNullValue() {
        return this.null_value_;
    }

    public final boolean hasNullValue() {
        return (this.optional_0_ & 1) != 0;
    }

    public Value clearNullValue() {
        this.optional_0_ &= 0xFFFFFFFE;
        this.null_value_ = 0;
        return this;
    }

    public Value setNullValue(int x) {
        this.optional_0_ |= 1;
        this.null_value_ = x;
        return this;
    }

    public final double getNumberValue() {
        return this.number_value_;
    }

    public final boolean hasNumberValue() {
        return (this.optional_0_ & 2) != 0;
    }

    public Value clearNumberValue() {
        this.optional_0_ &= 0xFFFFFFFD;
        this.number_value_ = 0.0;
        return this;
    }

    public Value setNumberValue(double x) {
        this.optional_0_ |= 2;
        this.number_value_ = x;
        return this;
    }

    public final byte[] getStringValueAsBytes() {
        if (ProtocolMessage.storeStringsOnlyAsBytes()) {
            return (byte[])this.string_value_;
        }
        byte[] string_value_tmp = ProtocolSupport.stringAsUtf8Bytes(this.string_value_);
        this.string_value_ = string_value_tmp;
        return string_value_tmp;
    }

    public final boolean hasStringValue() {
        return (this.optional_0_ & 4) != 0;
    }

    public Value clearStringValue() {
        this.optional_0_ &= 0xFFFFFFFB;
        this.string_value_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
        return this;
    }

    public Value setStringValueAsBytes(byte[] x) {
        this.optional_0_ |= 4;
        this.string_value_ = x;
        return this;
    }

    public final String getStringValue() {
        Object ref = this.string_value_;
        if (ref instanceof String) {
            return (String)ref;
        }
        byte[] bytes = (byte[])ref;
        String str = ProtocolSupport.toStringUtf8(bytes);
        if (!ProtocolMessage.storeStringsOnlyAsBytes() && Internal.isValidUtf8(bytes)) {
            this.string_value_ = str;
        }
        return str;
    }

    public Value setStringValue(String v) {
        if (v == null) {
            throw new NullPointerException();
        }
        this.optional_0_ |= 4;
        this.string_value_ = ProtocolMessage.storeStringsOnlyAsBytes() ? (Object)ProtocolSupport.toBytesUtf8(v) : v;
        return this;
    }

    public final String getStringValue(Charset cs) {
        if (ProtocolMessage.storeStringsOnlyAsBytes()) {
            return ProtocolSupport.toString((byte[])this.string_value_, cs);
        }
        byte[] string_value_tmp = ProtocolSupport.stringAsUtf8Bytes(this.string_value_);
        this.string_value_ = string_value_tmp;
        return ProtocolSupport.toString(string_value_tmp, cs);
    }

    public Value setStringValue(String v, Charset cs) {
        if (v == null) {
            throw new NullPointerException();
        }
        this.optional_0_ |= 4;
        this.string_value_ = ProtocolSupport.toBytes(v, cs);
        return this;
    }

    public final boolean isBoolValue() {
        return this.bool_value_;
    }

    public final boolean hasBoolValue() {
        return (this.optional_0_ & 8) != 0;
    }

    public Value clearBoolValue() {
        this.optional_0_ &= 0xFFFFFFF7;
        this.bool_value_ = false;
        return this;
    }

    public Value setBoolValue(boolean x) {
        this.optional_0_ |= 8;
        this.bool_value_ = x;
        return this;
    }

    public final Struct getStructValue() {
        if (this.struct_value_ == null) {
            return Struct.getDefaultInstance();
        }
        return this.struct_value_;
    }

    public final boolean hasStructValue() {
        return (this.optional_0_ & 0x10) != 0;
    }

    public Value clearStructValue() {
        this.optional_0_ &= 0xFFFFFFEF;
        if (this.struct_value_ != null) {
            this.struct_value_.clear();
        }
        return this;
    }

    public Value setStructValue(Struct x) {
        if (x == null) {
            throw new NullPointerException();
        }
        this.optional_0_ |= 0x10;
        this.struct_value_ = x;
        return this;
    }

    public Struct getMutableStructValue() {
        this.optional_0_ |= 0x10;
        if (this.struct_value_ == null) {
            this.struct_value_ = new Struct();
        }
        return this.struct_value_;
    }

    public final ListValue getListValue() {
        if (this.list_value_ == null) {
            return ListValue.getDefaultInstance();
        }
        return this.list_value_;
    }

    public final boolean hasListValue() {
        return (this.optional_0_ & 0x20) != 0;
    }

    public Value clearListValue() {
        this.optional_0_ &= 0xFFFFFFDF;
        if (this.list_value_ != null) {
            this.list_value_.clear();
        }
        return this;
    }

    public Value setListValue(ListValue x) {
        if (x == null) {
            throw new NullPointerException();
        }
        this.optional_0_ |= 0x20;
        this.list_value_ = x;
        return this;
    }

    public ListValue getMutableListValue() {
        this.optional_0_ |= 0x20;
        if (this.list_value_ == null) {
            this.list_value_ = new ListValue();
        }
        return this.list_value_;
    }

    @Override
    public Value mergeFrom(Value that) {
        ProtocolMessage v;
        assert (that != this);
        int this_t0 = this.optional_0_;
        int that_t0 = that.optional_0_;
        if ((that_t0 & 1) != 0) {
            this_t0 |= 1;
            this.null_value_ = that.null_value_;
        }
        if ((that_t0 & 2) != 0) {
            this_t0 |= 2;
            this.number_value_ = that.number_value_;
        }
        if ((that_t0 & 4) != 0) {
            this_t0 |= 4;
            this.string_value_ = that.string_value_;
        }
        if ((that_t0 & 8) != 0) {
            this_t0 |= 8;
            this.bool_value_ = that.bool_value_;
        }
        if ((that_t0 & 0x10) != 0) {
            this_t0 |= 0x10;
            v = this.struct_value_;
            if (v == null) {
                v = new Struct();
                this.struct_value_ = v;
            }
            ((Struct)v).mergeFrom(that.struct_value_);
        }
        if ((that_t0 & 0x20) != 0) {
            this_t0 |= 0x20;
            v = this.list_value_;
            if (v == null) {
                v = new ListValue();
                this.list_value_ = v;
            }
            ((ListValue)v).mergeFrom(that.list_value_);
        }
        if (that.uninterpreted != null) {
            this.getUninterpretedForWrite().putAll(that.uninterpreted);
        }
        this.optional_0_ = this_t0;
        return this;
    }

    @Override
    public boolean equalsIgnoreUninterpreted(Value that) {
        return this.equals(that, true);
    }

    @Override
    public boolean equals(Value that) {
        return this.equals(that, false);
    }

    @Override
    public boolean equals(Value that, boolean ignoreUninterpreted) {
        if (that == null) {
            return false;
        }
        if (that == this) {
            return true;
        }
        int this_t0 = this.optional_0_;
        int that_t0 = that.optional_0_;
        if (this_t0 != that_t0) {
            return false;
        }
        if ((this_t0 & 1) != 0 && this.null_value_ != that.null_value_) {
            return false;
        }
        if ((this_t0 & 2) != 0 && this.number_value_ != that.number_value_) {
            return false;
        }
        if ((this_t0 & 4) != 0 && !ProtocolSupport.stringEquals(this.string_value_, that.string_value_)) {
            return false;
        }
        if ((this_t0 & 8) != 0 && this.bool_value_ != that.bool_value_) {
            return false;
        }
        if ((this_t0 & 0x10) != 0 && !this.struct_value_.equals(that.struct_value_, ignoreUninterpreted)) {
            return false;
        }
        if ((this_t0 & 0x20) != 0 && !this.list_value_.equals(that.list_value_, ignoreUninterpreted)) {
            return false;
        }
        return ignoreUninterpreted || UninterpretedTags.equivalent(this.uninterpreted, that.uninterpreted);
    }

    @Override
    public boolean equals(Object that) {
        return that instanceof Value && this.equals((Value)that);
    }

    @Override
    public int hashCode() {
        int hash = -244436564;
        int this_t0 = this.optional_0_;
        hash = hash * 31 + ((this_t0 & 1) != 0 ? this.null_value_ : -113);
        hash = hash * 31 + ((this_t0 & 2) != 0 ? ProtocolSupport.hashCode(this.number_value_) : -113);
        hash = hash * 31 + ((this_t0 & 4) != 0 ? ProtocolSupport.stringHashCode(this.string_value_) : -113);
        hash = hash * 31 + ((this_t0 & 8) != 0 ? (this.bool_value_ ? 1231 : 1237) : -113);
        hash = hash * 31 + ((this_t0 & 0x10) != 0 ? this.struct_value_.hashCode() : -113);
        hash = hash * 31 + ((this_t0 & 0x20) != 0 ? this.list_value_.hashCode() : -113);
        if (this.uninterpreted != null && !this.uninterpreted.isEmpty()) {
            hash = hash * 31 + this.uninterpreted.hashCode();
        }
        return hash;
    }

    @Override
    public boolean isInitialized() {
        int this_t0 = this.optional_0_;
        if ((this_t0 & 0x10) != 0 && !this.struct_value_.isInitialized()) {
            return false;
        }
        return (this_t0 & 0x20) == 0 || this.list_value_.isInitialized();
    }

    @Override
    public int encodingSize() {
        int n = 0;
        int this_t0 = this.optional_0_;
        if ((this_t0 & 0x3F) != 0) {
            if ((this_t0 & 1) != 0) {
                n += 1 + Protocol.varLongSize(this.null_value_);
            }
            if ((this_t0 & 2) != 0) {
                n += 9;
            }
            if ((this_t0 & 4) != 0) {
                n += 1 + ProtocolSupport.stringEncodingSize(this.string_value_);
            }
            if ((this_t0 & 8) != 0) {
                n += 2;
            }
            if ((this_t0 & 0x10) != 0) {
                n += 1 + Protocol.stringSize(this.struct_value_.getSerializedSize());
            }
            if ((this_t0 & 0x20) != 0) {
                n += 1 + Protocol.stringSize(this.list_value_.getSerializedSize());
            }
        }
        return this.uninterpreted != null ? n + this.uninterpreted.encodingSize() : n;
    }

    @Override
    public int maxEncodingSize() {
        int n = 22;
        int this_t0 = this.optional_0_;
        if ((this_t0 & 0x34) != 0) {
            if ((this_t0 & 4) != 0) {
                n += 6 + ProtocolSupport.stringAsUtf8Bytes(this.string_value_).length;
            }
            if ((this_t0 & 0x10) != 0) {
                n += 6 + this.struct_value_.maxEncodingSize();
            }
            if ((this_t0 & 0x20) != 0) {
                n += 6 + this.list_value_.maxEncodingSize();
            }
        }
        return this.uninterpreted != null ? n + this.uninterpreted.maxEncodingSize() : n;
    }

    @Override
    public MessageAppender getMessageAppender() {
        return this.getUninterpretedForWrite();
    }

    @Override
    protected Value internalClear() {
        this.optional_0_ = 0;
        this.null_value_ = 0;
        this.number_value_ = 0.0;
        this.string_value_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
        this.bool_value_ = false;
        if (this.struct_value_ != null) {
            this.struct_value_.clear();
        }
        if (this.list_value_ != null) {
            this.list_value_.clear();
        }
        this.uninterpreted = null;
        return this;
    }

    @Override
    public Value newInstance() {
        return new Value();
    }

    @Override
    public ProtocolType getProtocolType() {
        return StaticHolder.protocolType;
    }

    @Override
    protected ProtocolMessage.FieldAccessorTable internalGetFieldAccessorTable() {
        return FieldAccessorTableHolder.internal_field_accessor_table;
    }

    public static Descriptors.Descriptor getDescriptor() {
        return FieldAccessorTableHolder.internal_field_accessor_table.getDescriptor();
    }

    @Override
    public void outputTo(ProtocolSink sink) {
        int this_t0 = this.optional_0_;
        if ((this_t0 & 1) != 0) {
            sink.putByte((byte)8);
            sink.putVarLong(this.null_value_);
        }
        if ((this_t0 & 2) != 0) {
            sink.putByte((byte)17);
            sink.putDouble(this.number_value_);
        }
        if ((this_t0 & 4) != 0) {
            sink.putByte((byte)26);
            sink.putPrefixedData(ProtocolSupport.stringAsUtf8Bytes(this.string_value_));
        }
        if ((this_t0 & 8) != 0) {
            sink.putByte((byte)32);
            sink.putBoolean(this.bool_value_);
        }
        if ((this_t0 & 0x10) != 0) {
            sink.putByte((byte)42);
            sink.putForeign(this.struct_value_);
        }
        if ((this_t0 & 0x20) != 0) {
            sink.putByte((byte)50);
            sink.putForeign(this.list_value_);
        }
        if (this.uninterpreted != null) {
            this.uninterpreted.put(sink);
        }
    }

    @Override
    public boolean merge(ProtocolSource source) {
        boolean result = true;
        int this_t0 = this.optional_0_;
        block9: while (source.hasRemaining()) {
            int tt = source.getVarInt();
            switch (tt) {
                case 0: {
                    result = false;
                    break block9;
                }
                case 8: {
                    this.null_value_ = source.getVarInt();
                    this_t0 |= 1;
                    continue block9;
                }
                case 17: {
                    this.number_value_ = source.getDouble();
                    this_t0 |= 2;
                    continue block9;
                }
                case 26: {
                    this.string_value_ = source.getPrefixedData();
                    this_t0 |= 4;
                    continue block9;
                }
                case 32: {
                    this.bool_value_ = source.getBoolean();
                    this_t0 |= 8;
                    continue block9;
                }
                case 42: {
                    source.push(source.getVarInt());
                    Struct v5 = this.struct_value_;
                    if (v5 == null) {
                        this.struct_value_ = v5 = new Struct();
                    }
                    if (!v5.merge(source)) {
                        result = false;
                        break block9;
                    }
                    source.pop();
                    this_t0 |= 0x10;
                    continue block9;
                }
                case 50: {
                    source.push(source.getVarInt());
                    ListValue v6 = this.list_value_;
                    if (v6 == null) {
                        this.list_value_ = v6 = new ListValue();
                    }
                    if (!v6.merge(source)) {
                        result = false;
                        break block9;
                    }
                    source.pop();
                    this_t0 |= 0x20;
                    continue block9;
                }
                default: {
                    this.getUninterpretedForWrite().putBytes(tt, source.getUninterpreted(tt));
                    continue block9;
                }
            }
        }
        this.optional_0_ = this_t0;
        return result;
    }

    @Override
    public Value getDefaultInstanceForType() {
        return IMMUTABLE_DEFAULT_INSTANCE;
    }

    public static final Value getDefaultInstance() {
        return IMMUTABLE_DEFAULT_INSTANCE;
    }

    @Override
    public Parser<Value> getParserForType() {
        return PARSER;
    }

    public static Parser<Value> parser() {
        return PARSER;
    }

    @Override
    public Value freeze() {
        this.string_value_ = ProtocolSupport.freezeString(this.string_value_);
        if (this.struct_value_ != null) {
            this.struct_value_.freeze();
        }
        if (this.list_value_ != null) {
            this.list_value_.freeze();
        }
        return this;
    }

    @Override
    public Value unfreeze() {
        if (this.struct_value_ != null) {
            this.struct_value_.unfreeze();
        }
        if (this.list_value_ != null) {
            this.list_value_.unfreeze();
        }
        return this;
    }

    @Override
    public boolean isFrozen() {
        return this.struct_value_ != null && this.struct_value_.isFrozen() || this.list_value_ != null && this.list_value_.isFrozen();
    }

    public UninterpretedTags getUninterpretedForWrite() {
        if (this.uninterpreted == null) {
            this.uninterpreted = new UninterpretedTags();
        }
        return this.uninterpreted;
    }

    @Override
    protected String internalGetImmutableClassName() {
        return "com.google.appengine.repackaged.com.google.protobuf.Value";
    }

    static {
        Value.text[0] = "ErrorCode";
        Value.text[1] = "null_value";
        Value.text[2] = "number_value";
        Value.text[3] = "string_value";
        Value.text[4] = "bool_value";
        Value.text[5] = "struct_value";
        Value.text[6] = "list_value";
        types = new int[7];
        Arrays.fill(types, 6);
        Value.types[0] = 0;
        Value.types[1] = 0;
        Value.types[2] = 1;
        Value.types[3] = 2;
        Value.types[4] = 0;
        Value.types[5] = 2;
        Value.types[6] = 2;
    }

    private static class FieldAccessorTableHolder {
        private static final ProtocolMessage.FieldAccessorTable internal_field_accessor_table = new ProtocolMessage.FieldAccessorTable(Value.class, StaticHolder.access$000(), "com.google.appengine.repackaged.com.google.protobuf.StructProtoInternalDescriptors", 1);

        private FieldAccessorTableHolder() {
        }
    }

    private static final class StaticHolder {
        private static final ProtocolType protocolType = ProtocolType.newProtocolType(Value.class, "Z\u001cgoogle/protobuf/struct.proto\n\u0015google.protobuf.Value\u0013\u001a\nnull_value \u0001(\u00000\u00058\u0001\u0014\u0013\u001a\fnumber_value \u0002(\u00010\u00018\u0001\u0014\u0013\u001a\fstring_value \u0003(\u00020\t8\u0001\u0014\u0013\u001a\nbool_value \u0004(\u00000\b8\u0001\u0014\u0013\u001a\fstruct_value \u0005(\u00020\u000b8\u0001J\u0016google.protobuf.Struct\u00a3\u0001\u00aa\u0001\u0005ctype\u00b2\u0001\u0006proto2\u00a4\u0001\u0014\u0013\u001a\nlist_value \u0006(\u00020\u000b8\u0001J\u0019google.protobuf.ListValue\u00a3\u0001\u00aa\u0001\u0005ctype\u00b2\u0001\u0006proto2\u00a4\u0001\u0014", new ProtocolType.FieldType("null_value", "null_value", 1, 0, ProtocolType.FieldBaseType.INT32, ProtocolType.Presence.OPTIONAL), new ProtocolType.FieldType("number_value", "number_value", 2, 1, ProtocolType.FieldBaseType.DOUBLE, ProtocolType.Presence.OPTIONAL), new ProtocolType.FieldType("string_value", "string_value", 3, 2, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.OPTIONAL), new ProtocolType.FieldType("bool_value", "bool_value", 4, 3, ProtocolType.FieldBaseType.BOOL, ProtocolType.Presence.OPTIONAL), new ProtocolType.FieldType("struct_value", "struct_value", 5, 4, ProtocolType.FieldBaseType.FOREIGN, ProtocolType.Presence.OPTIONAL, Struct.class), new ProtocolType.FieldType("list_value", "list_value", 6, 5, ProtocolType.FieldBaseType.FOREIGN, ProtocolType.Presence.OPTIONAL, ListValue.class));

        private StaticHolder() {
        }
    }
}

