/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal;

import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.StatusCode;
import javax.annotation.Nullable;

public class CheckedApiException
extends Exception {
    public final ApiException underlying;

    public static StatusCode fromCode(final StatusCode.Code code) {
        return new StatusCode(){

            public StatusCode.Code getCode() {
                return code;
            }

            public Object getTransportCode() {
                return null;
            }
        };
    }

    public CheckedApiException(ApiException underlying) {
        super(underlying.getMessage(), underlying);
        this.underlying = underlying;
    }

    public CheckedApiException(String message, @Nullable Throwable cause, StatusCode.Code code) {
        this(new ApiException(message, cause, CheckedApiException.fromCode(code), false));
    }

    public CheckedApiException(@Nullable Throwable cause, StatusCode.Code code) {
        this("", cause, code);
    }

    public CheckedApiException(String message, StatusCode.Code code) {
        this(message, null, code);
    }

    public CheckedApiException(StatusCode.Code code) {
        this("", code);
    }

    public StatusCode.Code code() {
        return this.underlying.getStatusCode().getCode();
    }
}

