/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal.wire;

import com.google.api.core.ApiFuture;
import com.google.api.gax.rpc.ApiException;
import com.google.cloud.pubsublite.Offset;
import com.google.cloud.pubsublite.internal.ProxyService;
import com.google.cloud.pubsublite.internal.PublishSequenceNumber;
import com.google.cloud.pubsublite.internal.Publisher;
import com.google.cloud.pubsublite.internal.SequencedPublisher;
import com.google.cloud.pubsublite.proto.PubSubMessage;
import java.io.IOException;
import javax.annotation.concurrent.GuardedBy;

public class SequenceAssigningPublisher
extends ProxyService
implements Publisher<Offset> {
    private final SequencedPublisher<Offset> publisher;
    @GuardedBy(value="this")
    private PublishSequenceNumber nextSequence = PublishSequenceNumber.FIRST;

    SequenceAssigningPublisher(SequencedPublisher<Offset> publisher) throws ApiException {
        super(publisher);
        this.publisher = publisher;
    }

    @Override
    public synchronized ApiFuture<Offset> publish(PubSubMessage message) {
        ApiFuture<Offset> future = this.publisher.publish(message, this.nextSequence);
        this.nextSequence = this.nextSequence.next();
        return future;
    }

    @Override
    public void cancelOutstandingPublishes() {
        this.publisher.cancelOutstandingPublishes();
    }

    @Override
    public void flush() throws IOException {
        this.publisher.flush();
    }
}

