/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsublite.internal.wire;

import com.google.cloud.pubsublite.internal.AlarmFactory;
import com.google.cloud.pubsublite.internal.wire.SystemExecutors;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Stopwatch;
import com.google.common.base.Ticker;
import com.google.common.collect.Comparators;
import java.time.Duration;
import java.util.concurrent.Future;
import javax.annotation.concurrent.GuardedBy;

class StreamIdleTimer
implements AutoCloseable {
    private static final long POLL_DIVISOR = 4L;
    private static final Duration MAX_POLL_INTERVAL = Duration.ofMinutes(1L);
    private final Duration timeout;
    private final Handler handler;
    private final Future<?> task;
    @GuardedBy(value="this")
    private final Stopwatch stopwatch;

    @VisibleForTesting
    static Duration getDelay(Duration timeout) {
        return (Duration)Comparators.min((Comparable)MAX_POLL_INTERVAL, (Comparable)timeout.dividedBy(4L));
    }

    StreamIdleTimer(Duration timeout, Handler handler) {
        this(timeout, handler, Ticker.systemTicker(), AlarmFactory.create(StreamIdleTimer.getDelay(timeout)));
    }

    @VisibleForTesting
    StreamIdleTimer(Duration timeout, Handler handler, Ticker ticker, AlarmFactory alarmFactory) {
        this.timeout = timeout;
        this.handler = handler;
        this.stopwatch = Stopwatch.createStarted((Ticker)ticker);
        this.task = alarmFactory.newAlarm(this::onPoll);
    }

    @Override
    public void close() throws Exception {
        this.task.cancel(false);
    }

    public synchronized void restart() {
        this.stopwatch.reset().start();
    }

    private synchronized void onPoll() {
        if (this.stopwatch.elapsed().compareTo(this.timeout) > 0) {
            SystemExecutors.getFuturesExecutor().execute(this.handler::onTimeout);
        }
    }

    static interface Handler {
        public void onTimeout();
    }
}

