/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase;

import com.google.auth.oauth2.GoogleCredentials;
import com.google.firebase.FirebaseApp;
import com.google.firebase.FirebaseOptions;
import com.google.firebase.internal.FirebaseService;
import com.google.firebase.internal.NonNull;
import com.google.firebase.tasks.Task;
import java.util.concurrent.Callable;
import java.util.concurrent.ThreadFactory;

public final class ImplFirebaseTrampolines {
    private ImplFirebaseTrampolines() {
    }

    public static GoogleCredentials getCredentials(@NonNull FirebaseApp app) {
        return app.getOptions().getCredentials();
    }

    public static String getProjectId(@NonNull FirebaseApp app) {
        return app.getProjectId();
    }

    public static boolean isDefaultApp(@NonNull FirebaseApp app) {
        return app.isDefaultApp();
    }

    public static String getPersistenceKey(@NonNull FirebaseApp app) {
        return app.getPersistenceKey();
    }

    public static String getPersistenceKey(String name, FirebaseOptions options) {
        return FirebaseApp.getPersistenceKey(name, options);
    }

    public static <T extends FirebaseService> T getService(@NonNull FirebaseApp app, @NonNull String id, @NonNull Class<T> type) {
        return (T)((FirebaseService)type.cast(app.getService(id)));
    }

    public static <T extends FirebaseService> T addService(@NonNull FirebaseApp app, @NonNull T service) {
        app.addService(service);
        return service;
    }

    public static ThreadFactory getThreadFactory(@NonNull FirebaseApp app) {
        return app.getThreadFactory();
    }

    public static <T> Task<T> submitCallable(@NonNull FirebaseApp app, @NonNull Callable<T> command) {
        return app.submit(command);
    }

    public static void startTokenRefresher(@NonNull FirebaseApp app) {
        app.startTokenRefresher();
    }
}

