/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.internal;

import com.google.common.base.Preconditions;
import com.google.firebase.internal.GaeExecutorService;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GaeThreadFactory
implements ThreadFactory {
    private static final Logger logger = LoggerFactory.getLogger(GaeThreadFactory.class);
    public static final ExecutorService DEFAULT_EXECUTOR = new GaeExecutorService("LegacyFirebaseDefault");
    private static final String GAE_THREAD_MANAGER_CLASS = "com.google.appengine.api.ThreadManager";
    private static final GaeThreadFactory instance = new GaeThreadFactory();
    private final AtomicReference<ThreadFactoryWrapper> threadFactory = new AtomicReference<Object>(null);

    private GaeThreadFactory() {
    }

    public static GaeThreadFactory getInstance() {
        return instance;
    }

    public static boolean isAvailable() {
        try {
            Class.forName(GAE_THREAD_MANAGER_CLASS);
            return System.getProperty("com.google.appengine.runtime.environment") != null;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static ThreadFactory createBackgroundFactory() throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Class<?> gaeThreadManager = Class.forName(GAE_THREAD_MANAGER_CLASS);
        return (ThreadFactory)gaeThreadManager.getMethod("backgroundThreadFactory", new Class[0]).invoke(null, new Object[0]);
    }

    private static ThreadFactory createRequestScopedFactory() throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Class<?> gaeThreadManager = Class.forName(GAE_THREAD_MANAGER_CLASS);
        return (ThreadFactory)gaeThreadManager.getMethod("currentRequestThreadFactory", new Class[0]).invoke(null, new Object[0]);
    }

    @Override
    public Thread newThread(Runnable r) {
        ThreadFactoryWrapper wrapper = this.threadFactory.get();
        if (wrapper != null) {
            return wrapper.getThreadFactory().newThread(r);
        }
        return this.initThreadFactory(r);
    }

    boolean isUsingBackgroundThreads() {
        ThreadFactoryWrapper wrapper = this.threadFactory.get();
        if (wrapper != null) {
            return wrapper.isUsingBackgroundThreads();
        }
        this.initThreadFactory(new Runnable(){

            @Override
            public void run() {
            }
        }).start();
        return this.threadFactory.get().isUsingBackgroundThreads();
    }

    private Thread initThreadFactory(Runnable r) {
        Thread thread;
        ThreadFactory threadFactory;
        boolean usesBackgroundThreads = false;
        try {
            try {
                threadFactory = GaeThreadFactory.createBackgroundFactory();
                thread = threadFactory.newThread(r);
                usesBackgroundThreads = true;
            }
            catch (IllegalStateException e) {
                logger.info("Falling back to GAE's request-scoped threads. Firebase requires manually-scaled instances for most operations.");
                threadFactory = GaeThreadFactory.createRequestScopedFactory();
                thread = threadFactory.newThread(r);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            threadFactory = new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    logger.warn("Failed to initialize native GAE thread factory. GaeThreadFactory cannot be used in a non-GAE environment.");
                    return null;
                }
            };
            thread = null;
        }
        ThreadFactoryWrapper wrapper = new ThreadFactoryWrapper(threadFactory, usesBackgroundThreads);
        this.threadFactory.compareAndSet(null, wrapper);
        return thread;
    }

    private static class ThreadFactoryWrapper {
        private final ThreadFactory threadFactory;
        private final boolean usingBackgroundThreads;

        private ThreadFactoryWrapper(ThreadFactory threadFactory, boolean usingBackgroundThreads) {
            this.threadFactory = (ThreadFactory)Preconditions.checkNotNull((Object)threadFactory);
            this.usingBackgroundThreads = usingBackgroundThreads;
        }

        ThreadFactory getThreadFactory() {
            return this.threadFactory;
        }

        boolean isUsingBackgroundThreads() {
            return this.usingBackgroundThreads;
        }
    }
}

