/*
 * Decompiled with CFR 0.152.
 */
package com.google.instrumentation.stats;

final class StringUtil {
    static final int MAX_LENGTH = 255;
    static final char UNPRINTABLE_CHAR_SUBSTITUTE = '_';

    static String sanitize(String string) {
        if (string.length() > 255) {
            string = string.substring(0, 255);
        }
        if (StringUtil.isPrintableString(string)) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            stringBuilder.append(StringUtil.isPrintableChar(c) ? c : (char)'_');
        }
        return stringBuilder.toString();
    }

    private static boolean isPrintableString(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (StringUtil.isPrintableChar(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isPrintableChar(char c) {
        return c >= ' ' && c <= '~';
    }

    StringUtil() {
        throw new AssertionError();
    }
}

