/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.base;

import com.ibm.icu.text.UFormat;
import java.text.FieldPosition;
import java.text.ParseException;
import java.text.ParsePosition;

public class BooleanFormat
extends UFormat {
    private String trueString;
    private String falseString;

    public BooleanFormat() {
        this("true", "false");
    }

    public BooleanFormat(String string, String string2) {
        if (string == null || string2 == null) {
            throw new NullPointerException();
        }
        this.trueString = string;
        this.falseString = string2;
    }

    public BooleanFormat(String string) {
        String[] stringArray = string.split(":");
        if (stringArray.length != 2) {
            throw new IllegalArgumentException("Cannot construct a boolean format from " + string + ". The pattern must contain a single ':' " + "character");
        }
        this.trueString = stringArray[0];
        this.falseString = stringArray[1];
    }

    public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        if (null != object && !(object instanceof Boolean)) {
            throw new IllegalArgumentException();
        }
        Boolean bl = (Boolean)object;
        if (bl == null) {
            fieldPosition.setBeginIndex(0);
            fieldPosition.setEndIndex(0);
        } else if (bl.booleanValue()) {
            stringBuffer.append(this.trueString);
            fieldPosition.setBeginIndex(0);
            fieldPosition.setEndIndex(this.trueString.length() - 1);
        } else {
            stringBuffer.append(this.falseString);
            fieldPosition.setBeginIndex(0);
            fieldPosition.setEndIndex(this.falseString.length() - 1);
        }
        return stringBuffer;
    }

    public Boolean parseObject(String string, ParsePosition parsePosition) {
        if (string == null) {
            throw new NullPointerException();
        }
        Boolean bl = null;
        if (this.trueString.equalsIgnoreCase(string.trim())) {
            bl = Boolean.TRUE;
            parsePosition.setIndex(this.trueString.length());
        } else if (this.falseString.equalsIgnoreCase(string.trim())) {
            bl = Boolean.FALSE;
            parsePosition.setIndex(this.falseString.length());
        }
        if (null == bl) {
            parsePosition.setErrorIndex(0);
        }
        return bl;
    }

    public Boolean parse(String string) throws ParseException {
        ParsePosition parsePosition = new ParsePosition(0);
        Boolean bl = this.parseObject(string, parsePosition);
        if (parsePosition.getIndex() == 0) {
            throw new ParseException("Unparseable boolean: \"" + string + '\"', parsePosition.getErrorIndex());
        }
        return bl;
    }
}

