/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.datatable;

import com.google.common.collect.Maps;
import com.google.visualization.datasource.datatable.value.ValueType;
import java.util.Collections;
import java.util.Map;

public class ColumnDescription {
    private String id;
    private ValueType type;
    private String label;
    private String pattern;
    private Map<String, String> customProperties = null;

    public ColumnDescription(String string, ValueType valueType, String string2) {
        this.id = string;
        this.type = valueType;
        this.label = string2;
        this.pattern = "";
    }

    public String getId() {
        return this.id;
    }

    public ValueType getType() {
        return this.type;
    }

    public String getLabel() {
        return this.label;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String string) {
        this.pattern = string;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public String getCustomProperty(String string) {
        if (this.customProperties == null) {
            return null;
        }
        if (string == null) {
            throw new RuntimeException("Null keys are not allowed.");
        }
        return this.customProperties.get(string);
    }

    public void setCustomProperty(String string, String string2) {
        if (this.customProperties == null) {
            this.customProperties = Maps.newHashMap();
        }
        if (string == null || string2 == null) {
            throw new RuntimeException("Null keys/values are not allowed.");
        }
        this.customProperties.put(string, string2);
    }

    public Map<String, String> getCustomProperties() {
        if (this.customProperties == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.customProperties);
    }

    public ColumnDescription clone() {
        ColumnDescription columnDescription = new ColumnDescription(this.id, this.type, this.label);
        columnDescription.setPattern(this.pattern);
        if (this.customProperties != null) {
            columnDescription.customProperties = Maps.newHashMap();
            for (Map.Entry<String, String> entry : this.customProperties.entrySet()) {
                columnDescription.customProperties.put(entry.getKey(), entry.getValue());
            }
        }
        return columnDescription;
    }
}

