/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.query;

import com.google.visualization.datasource.datatable.value.Value;
import com.google.visualization.datasource.query.QueryFilter;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public abstract class ComparisonFilter
extends QueryFilter {
    protected Operator operator;

    protected ComparisonFilter(Operator operator) {
        this.operator = operator;
    }

    private boolean isLike(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "%_", true);
        StringBuilder stringBuilder = new StringBuilder();
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (string3.equals("%")) {
                stringBuilder.append(".*");
                continue;
            }
            if (string3.equals("_")) {
                stringBuilder.append(".");
                continue;
            }
            stringBuilder.append(Pattern.quote(string3));
        }
        return string.matches(stringBuilder.toString());
    }

    protected boolean isOperatorMatch(Value value, Value value2) {
        if (this.operator.areEqualTypesRequired() && !value.getType().equals((Object)value2.getType())) {
            return false;
        }
        switch (this.operator) {
            case EQ: {
                return value.compareTo(value2) == 0;
            }
            case NE: {
                return value.compareTo(value2) != 0;
            }
            case LT: {
                return value.compareTo(value2) < 0;
            }
            case GT: {
                return value.compareTo(value2) > 0;
            }
            case LE: {
                return value.compareTo(value2) <= 0;
            }
            case GE: {
                return value.compareTo(value2) >= 0;
            }
            case CONTAINS: {
                return value.toString().contains(value2.toString());
            }
            case STARTS_WITH: {
                return value.toString().startsWith(value2.toString());
            }
            case ENDS_WITH: {
                return value.toString().endsWith(value2.toString());
            }
            case MATCHES: {
                try {
                    return value.toString().matches(value2.toString());
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    return false;
                }
            }
            case LIKE: {
                return this.isLike(value.toString(), value2.toString());
            }
        }
        return false;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    public static enum Operator {
        EQ("=", true),
        NE("!=", true),
        LT("<", true),
        GT(">", true),
        LE("<=", true),
        GE(">=", true),
        CONTAINS("CONTAINS", false),
        STARTS_WITH("STARTS WITH", false),
        ENDS_WITH("ENDS WITH", false),
        MATCHES("MATCHES", false),
        LIKE("LIKE", false);

        private boolean requiresEqualTypes;
        private String queryStringForm;

        private Operator(String string2, boolean bl) {
            this.queryStringForm = string2;
            this.requiresEqualTypes = bl;
        }

        public boolean areEqualTypesRequired() {
            return this.requiresEqualTypes;
        }

        public String toQueryString() {
            return this.queryStringForm;
        }
    }
}

