/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.render;

import com.google.common.collect.Lists;
import com.google.visualization.datasource.base.DataSourceParameters;
import com.google.visualization.datasource.base.OutputType;
import com.google.visualization.datasource.base.ReasonType;
import com.google.visualization.datasource.base.ResponseStatus;
import com.google.visualization.datasource.base.StatusType;
import com.google.visualization.datasource.base.Warning;
import com.google.visualization.datasource.datatable.ColumnDescription;
import com.google.visualization.datasource.datatable.DataTable;
import com.google.visualization.datasource.datatable.TableCell;
import com.google.visualization.datasource.datatable.TableRow;
import com.google.visualization.datasource.datatable.value.BooleanValue;
import com.google.visualization.datasource.datatable.value.DateTimeValue;
import com.google.visualization.datasource.datatable.value.DateValue;
import com.google.visualization.datasource.datatable.value.NumberValue;
import com.google.visualization.datasource.datatable.value.TimeOfDayValue;
import com.google.visualization.datasource.datatable.value.Value;
import com.google.visualization.datasource.datatable.value.ValueType;
import com.google.visualization.datasource.render.EscapeUtil;
import com.ibm.icu.util.GregorianCalendar;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrBuilder;

public class JsonRenderer {
    private JsonRenderer() {
    }

    public static String getSignature(DataTable dataTable) {
        String string = ((Object)JsonRenderer.renderDataTable(dataTable, true, false, true)).toString();
        long l = string.hashCode();
        return String.valueOf(Math.abs(l));
    }

    private static String getFaultString(ReasonType reasonType, String string) {
        ArrayList arrayList = Lists.newArrayList();
        if (reasonType != null) {
            arrayList.add("\"reason\":\"" + reasonType.lowerCaseString() + "\"");
            arrayList.add("\"message\":\"" + EscapeUtil.jsonEscape(reasonType.getMessageForReasonType(null)) + "\"");
        }
        if (string != null) {
            arrayList.add("\"detailed_message\":\"" + EscapeUtil.jsonEscape(string) + "\"");
        }
        return new StrBuilder("{").appendWithSeparators((Collection)arrayList, ",").append("}").toString();
    }

    @Deprecated
    public static CharSequence renderJsonResponse(DataSourceParameters dataSourceParameters, ResponseStatus responseStatus, DataTable dataTable, boolean bl) {
        dataSourceParameters.setOutputType(OutputType.JSONP);
        return JsonRenderer.renderJsonResponse(dataSourceParameters, responseStatus, dataTable);
    }

    public static CharSequence renderJsonResponse(DataSourceParameters dataSourceParameters, ResponseStatus responseStatus, DataTable dataTable) {
        boolean bl;
        StrBuilder strBuilder = new StrBuilder();
        boolean bl2 = bl = dataSourceParameters.getOutputType() == OutputType.JSONP;
        if (bl) {
            strBuilder.append(dataSourceParameters.getResponseHandler()).append("(");
        }
        strBuilder.append("{\"version\":\"0.6\"");
        String string = dataSourceParameters.getRequestId();
        if (string != null) {
            strBuilder.append(",\"reqId\":\"").append(EscapeUtil.jsonEscape(string)).append("\"");
        }
        String string2 = dataSourceParameters.getSignature();
        if (responseStatus == null) {
            responseStatus = !StringUtils.isEmpty((String)string2) && dataTable != null && JsonRenderer.getSignature(dataTable).equals(string2) ? new ResponseStatus(StatusType.ERROR, ReasonType.NOT_MODIFIED, null) : new ResponseStatus(StatusType.OK, null, null);
        }
        StatusType statusType = responseStatus.getStatusType();
        strBuilder.append(",\"status\":\"").append(statusType.lowerCaseString()).append("\"");
        if (statusType != StatusType.OK) {
            if (statusType == StatusType.WARNING) {
                List<Warning> list = dataTable.getWarnings();
                ArrayList arrayList = Lists.newArrayList();
                if (list != null) {
                    for (Warning warning : list) {
                        arrayList.add(JsonRenderer.getFaultString(warning.getReasonType(), warning.getMessage()));
                    }
                }
                strBuilder.append(",\"warnings\":[").appendWithSeparators((Collection)arrayList, ",").append("]");
            } else {
                strBuilder.append(",\"errors\":[");
                strBuilder.append(JsonRenderer.getFaultString(responseStatus.getReasonType(), responseStatus.getDescription()));
                strBuilder.append("]");
            }
        }
        if (statusType != StatusType.ERROR && dataTable != null) {
            strBuilder.append(",\"sig\":\"").append(JsonRenderer.getSignature(dataTable)).append("\"");
            strBuilder.append(",\"table\":").append((Object)JsonRenderer.renderDataTable(dataTable, true, true, bl));
        }
        strBuilder.append("}");
        if (bl) {
            strBuilder.append(");");
        }
        return strBuilder.toString();
    }

    @Deprecated
    public static CharSequence renderDataTable(DataTable dataTable, boolean bl, boolean bl2) {
        return JsonRenderer.renderDataTable(dataTable, bl, bl2, true);
    }

    public static CharSequence renderDataTable(DataTable dataTable, boolean bl, boolean bl2, boolean bl3) {
        String string;
        if (dataTable.getColumnDescriptions().isEmpty()) {
            return "";
        }
        List<ColumnDescription> list = dataTable.getColumnDescriptions();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        stringBuilder.append("\"cols\":[");
        for (int i = 0; i < list.size(); ++i) {
            ColumnDescription columnDescription = list.get(i);
            JsonRenderer.appendColumnDescriptionJson(columnDescription, stringBuilder);
            if (i == list.size() - 1) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append("]");
        if (bl) {
            stringBuilder.append(",\"rows\":[");
            List<TableRow> list2 = dataTable.getRows();
            for (int i = 0; i < list2.size(); ++i) {
                TableRow tableRow = list2.get(i);
                List<TableCell> list3 = tableRow.getCells();
                stringBuilder.append("{\"c\":[");
                for (int j = 0; j < list3.size(); ++j) {
                    TableCell tableCell = list3.get(j);
                    if (j < list3.size() - 1) {
                        JsonRenderer.appendCellJson(tableCell, stringBuilder, bl2, false, bl3);
                        stringBuilder.append(",");
                        continue;
                    }
                    JsonRenderer.appendCellJson(tableCell, stringBuilder, bl2, true, bl3);
                }
                stringBuilder.append("]");
                String string2 = JsonRenderer.getPropertiesMapString(tableRow.getCustomProperties());
                if (string2 != null) {
                    stringBuilder.append(",\"p\":").append(string2);
                }
                stringBuilder.append("}");
                if (list2.size() - 1 <= i) continue;
                stringBuilder.append(",");
            }
            stringBuilder.append("]");
        }
        if ((string = JsonRenderer.getPropertiesMapString(dataTable.getCustomProperties())) != null) {
            stringBuilder.append(",\"p\":").append(string);
        }
        stringBuilder.append("}");
        return stringBuilder;
    }

    @Deprecated
    public static StringBuilder appendCellJson(TableCell tableCell, StringBuilder stringBuilder, boolean bl, boolean bl2) {
        return JsonRenderer.appendCellJson(tableCell, stringBuilder, bl, bl2, true);
    }

    static StringBuilder appendCellJson(TableCell tableCell, StringBuilder stringBuilder, boolean bl, boolean bl2, boolean bl3) {
        Value value = tableCell.getValue();
        ValueType valueType = tableCell.getType();
        StringBuilder stringBuilder2 = new StringBuilder();
        String string = "";
        boolean bl4 = false;
        if (value == null || value.isNull()) {
            stringBuilder2.append("null");
            bl4 = true;
        } else {
            switch (valueType) {
                case BOOLEAN: {
                    stringBuilder2.append(((BooleanValue)value).getValue());
                    break;
                }
                case DATE: {
                    stringBuilder2.append("Date(");
                    DateValue dateValue = (DateValue)value;
                    stringBuilder2.append(dateValue.getYear()).append(",");
                    stringBuilder2.append(dateValue.getMonth()).append(",");
                    stringBuilder2.append(dateValue.getDayOfMonth());
                    stringBuilder2.append(")");
                    if (bl3) {
                        stringBuilder2.insert(0, "new ");
                        break;
                    }
                    stringBuilder2.insert(0, "\"");
                    stringBuilder2.append("\"");
                    break;
                }
                case NUMBER: {
                    stringBuilder2.append(((NumberValue)value).getValue());
                    break;
                }
                case TEXT: {
                    stringBuilder2.append("\"");
                    stringBuilder2.append(EscapeUtil.jsonEscape(value.toString()));
                    stringBuilder2.append("\"");
                    break;
                }
                case TIMEOFDAY: {
                    stringBuilder2.append("[");
                    TimeOfDayValue timeOfDayValue = (TimeOfDayValue)value;
                    stringBuilder2.append(timeOfDayValue.getHours()).append(",");
                    stringBuilder2.append(timeOfDayValue.getMinutes()).append(",");
                    stringBuilder2.append(timeOfDayValue.getSeconds()).append(",");
                    stringBuilder2.append(timeOfDayValue.getMilliseconds());
                    stringBuilder2.append("]");
                    break;
                }
                case DATETIME: {
                    GregorianCalendar gregorianCalendar = ((DateTimeValue)value).getCalendar();
                    stringBuilder2.append("Date(");
                    stringBuilder2.append(gregorianCalendar.get(1)).append(",");
                    stringBuilder2.append(gregorianCalendar.get(2)).append(",");
                    stringBuilder2.append(gregorianCalendar.get(5));
                    stringBuilder2.append(",");
                    stringBuilder2.append(gregorianCalendar.get(11));
                    stringBuilder2.append(",");
                    stringBuilder2.append(gregorianCalendar.get(12)).append(",");
                    stringBuilder2.append(gregorianCalendar.get(13));
                    stringBuilder2.append(")");
                    if (bl3) {
                        stringBuilder2.insert(0, "new ");
                        break;
                    }
                    stringBuilder2.insert(0, "\"");
                    stringBuilder2.append("\"");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal value Type " + (Object)((Object)valueType));
                }
            }
        }
        String string2 = tableCell.getFormattedValue();
        if (value != null && !value.isNull() && string2 != null) {
            string = EscapeUtil.jsonEscape(string2);
            if (valueType == ValueType.TEXT && value.toString().equals(string2)) {
                string = "";
            }
        }
        if (bl2 || !bl4) {
            String string3;
            stringBuilder.append("{");
            stringBuilder.append("\"v\":").append((CharSequence)stringBuilder2);
            if (bl && !string.equals("")) {
                stringBuilder.append(",\"f\":\"").append(string).append("\"");
            }
            if ((string3 = JsonRenderer.getPropertiesMapString(tableCell.getCustomProperties())) != null) {
                stringBuilder.append(",\"p\":").append(string3);
            }
            stringBuilder.append("}");
        }
        return stringBuilder;
    }

    public static StringBuilder appendColumnDescriptionJson(ColumnDescription columnDescription, StringBuilder stringBuilder) {
        stringBuilder.append("{");
        stringBuilder.append("\"id\":\"").append(EscapeUtil.jsonEscape(columnDescription.getId())).append("\",");
        stringBuilder.append("\"label\":\"").append(EscapeUtil.jsonEscape(columnDescription.getLabel())).append("\",");
        stringBuilder.append("\"type\":\"").append(columnDescription.getType().getTypeCodeLowerCase()).append("\",");
        stringBuilder.append("\"pattern\":\"").append(EscapeUtil.jsonEscape(columnDescription.getPattern())).append("\"");
        String string = JsonRenderer.getPropertiesMapString(columnDescription.getCustomProperties());
        if (string != null) {
            stringBuilder.append(",\"p\":").append(string);
        }
        stringBuilder.append("}");
        return stringBuilder;
    }

    private static String getPropertiesMapString(Map<String, String> map) {
        String string = null;
        if (map != null && !map.isEmpty()) {
            ArrayList arrayList = Lists.newArrayList();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                arrayList.add("\"" + EscapeUtil.jsonEscape(entry.getKey()) + "\":\"" + EscapeUtil.jsonEscape(entry.getValue()) + "\"");
            }
            string = new StrBuilder("{").appendWithSeparators((Collection)arrayList, ",").append("}").toString();
        }
        return string;
    }
}

