/*
 * Decompiled with CFR 0.152.
 */
package com.guichaguri.minimalftp;

import com.guichaguri.minimalftp.FTPServer;
import com.guichaguri.minimalftp.Utils;
import com.guichaguri.minimalftp.api.CommandInfo;
import com.guichaguri.minimalftp.api.IFileSystem;
import com.guichaguri.minimalftp.api.ResponseException;
import com.guichaguri.minimalftp.handler.ConnectionHandler;
import com.guichaguri.minimalftp.handler.FileHandler;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class FTPConnection
implements Closeable {
    protected final Map<String, CommandInfo> commands = new HashMap<String, CommandInfo>();
    protected final Map<String, CommandInfo> siteCommands = new HashMap<String, CommandInfo>();
    protected final List<String> features = new ArrayList<String>();
    protected final Map<String, String> options = new HashMap<String, String>();
    protected final FTPServer server;
    protected Socket con;
    protected BufferedReader reader;
    protected BufferedWriter writer;
    protected final ConnectionThread thread;
    protected final ArrayDeque<Socket> dataConnections = new ArrayDeque();
    protected ConnectionHandler conHandler;
    protected FileHandler fileHandler;
    protected long bytesTransferred = 0L;
    protected boolean responseSent = true;
    protected int timeout = 0;
    protected int bufferSize = 0;
    protected long lastUpdate = 0L;

    public FTPConnection(FTPServer server, Socket con, int idleTimeout, int bufferSize) throws IOException {
        this.server = server;
        this.con = con;
        this.reader = new BufferedReader(new InputStreamReader(con.getInputStream()));
        this.writer = new BufferedWriter(new OutputStreamWriter(con.getOutputStream()));
        this.timeout = idleTimeout;
        this.bufferSize = bufferSize;
        this.lastUpdate = System.currentTimeMillis();
        con.setSoTimeout(this.timeout);
        this.conHandler = new ConnectionHandler(this);
        this.fileHandler = new FileHandler(this);
        this.thread = new ConnectionThread();
        this.thread.start();
        this.registerCommand("SITE", "SITE <command>", this::site);
        this.registerCommand("FEAT", "FEAT", this::feat, false);
        this.registerCommand("OPTS", "OPTS <option> [value]", this::opts);
        this.registerFeature("feat");
        this.registerFeature("UTF8");
        this.registerOption("UTF8", "ON");
        this.conHandler.registerCommands();
        this.fileHandler.registerCommands();
        this.conHandler.onConnected();
    }

    @Deprecated
    public FTPConnection(FTPServer server, Socket con, int idleTimeout) throws IOException {
        this(server, con, idleTimeout, 1024);
    }

    public FTPServer getServer() {
        return this.server;
    }

    public InetAddress getAddress() {
        return this.con.getInetAddress();
    }

    public long getBytesTransferred() {
        return this.bytesTransferred;
    }

    public boolean isAuthenticated() {
        return this.conHandler.isAuthenticated();
    }

    public String getUsername() {
        return this.conHandler.getUsername();
    }

    public boolean isAsciiMode() {
        return this.conHandler.isAsciiMode();
    }

    public IFileSystem getFileSystem() {
        return this.fileHandler.getFileSystem();
    }

    public void setFileSystem(IFileSystem fs) {
        this.fileHandler.setFileSystem(fs);
    }

    public boolean isSSLEnabled() {
        return this.con instanceof SSLSocket;
    }

    public void enableSSL(SSLContext context) throws IOException {
        SSLSocketFactory factory = context.getSocketFactory();
        this.con = factory.createSocket(this.con, this.con.getInetAddress().getHostAddress(), this.con.getPort(), true);
        ((SSLSocket)this.con).setUseClientMode(false);
        this.reader = new BufferedReader(new InputStreamReader(this.con.getInputStream()));
        this.writer = new BufferedWriter(new OutputStreamWriter(this.con.getOutputStream()));
    }

    public void sendResponse(int code, String response) {
        if (this.con.isClosed()) {
            return;
        }
        if (response == null || response.isEmpty()) {
            response = "Unknown";
        }
        try {
            if (response.charAt(0) == '-') {
                this.writer.write(code + response + "\r\n");
            } else {
                this.writer.write(code + " " + response + "\r\n");
            }
            this.writer.flush();
        }
        catch (IOException ex) {
            Utils.closeQuietly(this);
        }
        this.responseSent = true;
    }

    public void sendData(byte[] data) throws ResponseException {
        if (this.con.isClosed()) {
            return;
        }
        Socket socket = null;
        try {
            socket = this.conHandler.createDataSocket();
            this.dataConnections.add(socket);
            OutputStream out = socket.getOutputStream();
            Utils.write(out, data, data.length, this.conHandler.isAsciiMode());
            this.bytesTransferred += (long)data.length;
            out.flush();
            Utils.closeQuietly(out);
            Utils.closeQuietly(socket);
        }
        catch (SocketException ex) {
            throw new ResponseException(426, "Transfer aborted");
        }
        catch (IOException ex) {
            throw new ResponseException(425, "An error occurred while transferring the data");
        }
        finally {
            this.onUpdate();
            if (socket != null) {
                this.dataConnections.remove(socket);
            }
        }
    }

    public void sendData(InputStream in) throws ResponseException {
        if (this.con.isClosed()) {
            return;
        }
        Socket socket = null;
        try {
            int len;
            socket = this.conHandler.createDataSocket();
            this.dataConnections.add(socket);
            OutputStream out = socket.getOutputStream();
            byte[] buffer = new byte[this.bufferSize];
            while ((len = in.read(buffer)) != -1) {
                Utils.write(out, buffer, len, this.conHandler.isAsciiMode());
                this.bytesTransferred += (long)len;
            }
            out.flush();
            Utils.closeQuietly(out);
            Utils.closeQuietly(in);
            Utils.closeQuietly(socket);
        }
        catch (SocketException ex) {
            throw new ResponseException(426, "Transfer aborted");
        }
        catch (IOException ex) {
            throw new ResponseException(425, "An error occurred while transferring the data");
        }
        finally {
            this.onUpdate();
            if (socket != null) {
                this.dataConnections.remove(socket);
            }
        }
    }

    public void receiveData(OutputStream out) throws ResponseException {
        if (this.con.isClosed()) {
            return;
        }
        Socket socket = null;
        try {
            int len;
            socket = this.conHandler.createDataSocket();
            this.dataConnections.add(socket);
            InputStream in = socket.getInputStream();
            byte[] buffer = new byte[this.bufferSize];
            while ((len = in.read(buffer)) != -1) {
                out.write(buffer, 0, len);
                this.bytesTransferred += (long)len;
            }
            out.flush();
            Utils.closeQuietly(out);
            Utils.closeQuietly(in);
            Utils.closeQuietly(socket);
        }
        catch (SocketException ex) {
            throw new ResponseException(426, "Transfer aborted");
        }
        catch (IOException ex) {
            throw new ResponseException(425, "An error occurred while transferring the data");
        }
        finally {
            this.onUpdate();
            if (socket != null) {
                this.dataConnections.remove(socket);
            }
        }
    }

    public void abortDataTransfers() {
        while (!this.dataConnections.isEmpty()) {
            Socket socket = this.dataConnections.poll();
            if (socket == null) continue;
            Utils.closeQuietly(socket);
        }
    }

    public void registerFeature(String feat) {
        if (!this.features.contains(feat)) {
            this.features.add(feat);
        }
    }

    public void registerOption(String option, String value) {
        this.options.put(option.toUpperCase(), value);
    }

    public String getOption(String option) {
        return this.options.get(option.toUpperCase());
    }

    public void registerSiteCommand(String label, String help, CommandInfo.Command cmd) {
        this.addSiteCommand(label, help, cmd);
    }

    public void registerSiteCommand(String label, String help, CommandInfo.NoArgsCommand cmd) {
        this.addSiteCommand(label, help, cmd);
    }

    public void registerSiteCommand(String label, String help, CommandInfo.ArgsArrayCommand cmd) {
        this.addSiteCommand(label, help, cmd);
    }

    public void registerCommand(String label, String help, CommandInfo.Command cmd) {
        this.addCommand(label, help, cmd, true);
    }

    public void registerCommand(String label, String help, CommandInfo.NoArgsCommand cmd) {
        this.addCommand(label, help, cmd, true);
    }

    public void registerCommand(String label, String help, CommandInfo.ArgsArrayCommand cmd) {
        this.addCommand(label, help, cmd, true);
    }

    public void registerCommand(String label, String help, CommandInfo.Command cmd, boolean needsAuth) {
        this.addCommand(label, help, cmd, needsAuth);
    }

    public void registerCommand(String label, String help, CommandInfo.NoArgsCommand cmd, boolean needsAuth) {
        this.addCommand(label, help, cmd, needsAuth);
    }

    public void registerCommand(String label, String help, CommandInfo.ArgsArrayCommand cmd, boolean needsAuth) {
        this.addCommand(label, help, cmd, needsAuth);
    }

    protected void addSiteCommand(String label, String help, CommandInfo.Command cmd) {
        this.siteCommands.put(label.toUpperCase(), new CommandInfo(cmd, help, true));
    }

    protected void addCommand(String label, String help, CommandInfo.Command cmd, boolean needsAuth) {
        this.commands.put(label.toUpperCase(), new CommandInfo(cmd, help, needsAuth));
    }

    public String getSiteHelpMessage(String label) {
        CommandInfo info = this.siteCommands.get(label);
        return info != null ? info.help : null;
    }

    public String getHelpMessage(String label) {
        CommandInfo info = this.commands.get(label);
        return info != null ? info.help : null;
    }

    protected void onUpdate() {
        this.lastUpdate = System.currentTimeMillis();
    }

    protected void process(String cmd) {
        CommandInfo info;
        int firstSpace = cmd.indexOf(32);
        if (firstSpace < 0) {
            firstSpace = cmd.length();
        }
        if ((info = this.commands.get(cmd.substring(0, firstSpace).toUpperCase())) == null) {
            this.sendResponse(502, "Unknown command");
            return;
        }
        this.processCommand(info, firstSpace != cmd.length() ? cmd.substring(firstSpace + 1) : "");
    }

    protected void site(String cmd) {
        CommandInfo info;
        int firstSpace = cmd.indexOf(32);
        if (firstSpace < 0) {
            firstSpace = cmd.length();
        }
        if ((info = this.siteCommands.get(cmd.substring(0, firstSpace).toUpperCase())) == null) {
            this.sendResponse(504, "Unknown site command");
            return;
        }
        this.processCommand(info, firstSpace != cmd.length() ? cmd.substring(firstSpace + 1) : "");
    }

    protected void feat() {
        StringBuilder list = new StringBuilder();
        list.append("- Supported Features:\r\n");
        for (String feat : this.features) {
            list.append(' ').append(feat).append("\r\n");
        }
        this.sendResponse(211, list.toString());
        this.sendResponse(211, "End");
    }

    protected void opts(String[] opts) {
        if (opts.length < 1) {
            this.sendResponse(501, "Missing parameters");
            return;
        }
        String option = opts[0].toUpperCase();
        if (!this.options.containsKey(option)) {
            this.sendResponse(501, "No option found");
        } else if (opts.length < 2) {
            this.sendResponse(200, this.options.get(option));
        } else {
            this.options.put(option, opts[1].toUpperCase());
            this.sendResponse(200, "Option updated");
        }
    }

    protected void processCommand(CommandInfo info, String args) {
        if (info.needsAuth && !this.conHandler.isAuthenticated()) {
            this.sendResponse(530, "Needs authentication");
            return;
        }
        this.responseSent = false;
        try {
            info.command.run(info, args);
        }
        catch (ResponseException ex) {
            this.sendResponse(ex.getCode(), ex.getMessage());
        }
        catch (FileNotFoundException ex) {
            this.sendResponse(550, ex.getMessage());
        }
        catch (IOException ex) {
            this.sendResponse(450, ex.getMessage());
        }
        catch (Exception ex) {
            this.sendResponse(451, ex.getMessage());
            ex.printStackTrace();
        }
        if (!this.responseSent) {
            this.sendResponse(200, "Done");
        }
    }

    protected void update() {
        String line;
        if (this.conHandler.shouldStop()) {
            Utils.closeQuietly(this);
            return;
        }
        try {
            line = this.reader.readLine();
        }
        catch (SocketTimeoutException ex) {
            if (!this.dataConnections.isEmpty() && System.currentTimeMillis() - this.lastUpdate >= (long)this.timeout) {
                Utils.closeQuietly(this);
            }
            return;
        }
        catch (IOException ex) {
            return;
        }
        if (line == null) {
            Utils.closeQuietly(this);
            return;
        }
        if (line.isEmpty()) {
            return;
        }
        this.process(line);
    }

    protected void stop(boolean close) throws IOException {
        if (!this.thread.isInterrupted()) {
            this.thread.interrupt();
        }
        this.conHandler.onDisconnected();
        if (close) {
            this.con.close();
        }
    }

    protected void close(boolean close) throws IOException {
        this.stop(close);
        this.server.removeConnection(this);
    }

    @Override
    public void close() throws IOException {
        this.close(true);
    }

    private class ConnectionThread
    extends Thread {
        private ConnectionThread() {
        }

        @Override
        public void run() {
            while (!FTPConnection.this.con.isClosed()) {
                FTPConnection.this.update();
            }
            try {
                FTPConnection.this.close(false);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }
}

