/*
 * Decompiled with CFR 0.152.
 */
package com.guichaguri.minimalftp.api;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public interface IFileSystem<F> {
    public F getRoot();

    public String getPath(F var1);

    public boolean exists(F var1);

    public boolean isDirectory(F var1);

    public int getPermissions(F var1);

    public long getSize(F var1);

    public long getLastModified(F var1);

    public int getHardLinks(F var1);

    public String getName(F var1);

    public String getOwner(F var1);

    public String getGroup(F var1);

    default public byte[] getDigest(F file, String algorithm) throws IOException, NoSuchAlgorithmException {
        int length;
        MessageDigest d = MessageDigest.getInstance(algorithm);
        InputStream in = this.readFile(file, 0L);
        byte[] bytes = new byte[1024];
        while ((length = in.read(bytes)) != -1) {
            d.update(bytes, 0, length);
        }
        return d.digest();
    }

    public F getParent(F var1) throws IOException;

    public F[] listFiles(F var1) throws IOException;

    public F findFile(String var1) throws IOException;

    public F findFile(F var1, String var2) throws IOException;

    public InputStream readFile(F var1, long var2) throws IOException;

    public OutputStream writeFile(F var1, long var2) throws IOException;

    public void mkdirs(F var1) throws IOException;

    public void delete(F var1) throws IOException;

    public void rename(F var1, F var2) throws IOException;

    public void chmod(F var1, int var2) throws IOException;

    public void touch(F var1, long var2) throws IOException;
}

