/*
 * Decompiled with CFR 0.152.
 */
package com.guichaguri.minimalftp.handler;

import com.guichaguri.minimalftp.FTPConnection;
import com.guichaguri.minimalftp.FTPServer;
import com.guichaguri.minimalftp.Utils;
import com.guichaguri.minimalftp.api.IUserAuthenticator;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class ConnectionHandler {
    private final FTPConnection con;
    private InetAddress address = null;
    private boolean authenticated = false;
    private String username = null;
    private boolean passive = false;
    private ServerSocket passiveServer = null;
    private String activeHost = null;
    private int activePort = 0;
    private boolean ascii = true;
    private boolean secureData = false;
    private boolean stop = false;

    public ConnectionHandler(FTPConnection connection) {
        this.con = connection;
    }

    public boolean shouldStop() {
        return this.stop;
    }

    public boolean isAsciiMode() {
        return this.ascii;
    }

    public boolean isAuthenticated() {
        return this.authenticated;
    }

    public String getUsername() {
        return this.username;
    }

    public Socket createDataSocket() throws IOException {
        if (this.passive && this.passiveServer != null) {
            return this.passiveServer.accept();
        }
        if (this.secureData) {
            SSLSocketFactory factory = this.con.getServer().getSSLContext().getSocketFactory();
            SSLSocket socket = (SSLSocket)factory.createSocket(this.activeHost, this.activePort);
            socket.setUseClientMode(false);
            return socket;
        }
        return new Socket(this.activeHost, this.activePort);
    }

    public void onConnected() throws IOException {
        IUserAuthenticator auth = this.con.getServer().getAuthenticator();
        if (!auth.needsUsername(this.con)) {
            if (this.authenticate(auth, null)) {
                this.con.sendResponse(230, "Ready!");
            } else {
                this.con.sendResponse(421, "Authentication failed");
                this.con.close();
            }
        } else {
            this.con.sendResponse(220, "Waiting for authentication...");
        }
    }

    public void onDisconnected() throws IOException {
        if (this.passiveServer != null) {
            Utils.closeQuietly(this.passiveServer);
            this.passiveServer = null;
        }
    }

    public void registerCommands() {
        this.con.registerCommand("NOOP", "NOOP", this::noop, false);
        this.con.registerCommand("HELP", "HELP <command>", this::help, false);
        this.con.registerCommand("QUIT", "QUIT", this::quit, false);
        this.con.registerCommand("REIN", "REIN", this::rein, false);
        this.con.registerCommand("USER", "USER <username>", this::user, false);
        this.con.registerCommand("PASS", "PASS <password>", this::pass, false);
        this.con.registerCommand("ACCT", "ACCT <info>", this::acct, false);
        this.con.registerCommand("SYST", "SYST", this::syst);
        this.con.registerCommand("PASV", "PASV", this::pasv);
        this.con.registerCommand("PORT", "PORT <address>", this::port);
        this.con.registerCommand("TYPE", "TYPE <type>", this::type);
        this.con.registerCommand("STRU", "STRU <type>", this::stru);
        this.con.registerCommand("MODE", "MODE <mode>", this::mode);
        this.con.registerCommand("STAT", "STAT", this::stat);
        this.con.registerCommand("AUTH", "AUTH <mechanism>", this::auth, false);
        this.con.registerCommand("PBSZ", "PBSZ <size>", this::pbsz, false);
        this.con.registerCommand("PROT", "PROT <level>", this::prot, false);
        this.con.registerCommand("LPSV", "LPSV", this::lpsv);
        this.con.registerCommand("LPRT", "LPRT <address>", this::lprt);
        this.con.registerCommand("EPSV", "EPSV", this::epsv);
        this.con.registerCommand("EPRT", "EPRT <address>", this::eprt);
        this.con.registerCommand("HOST", "HOST <address>", this::host, false);
        this.con.registerFeature("base");
        this.con.registerFeature("secu");
        this.con.registerFeature("hist");
        this.con.registerFeature("nat6");
        this.con.registerFeature("TYPE A;AN;AT;AC;L;I");
        this.con.registerFeature("AUTH TLS");
        this.con.registerFeature("PBSZ");
        this.con.registerFeature("PROT");
        this.con.registerFeature("EPSV");
        this.con.registerFeature("EPRT");
        this.con.registerFeature("HOST");
    }

    private void noop() {
        this.con.sendResponse(200, "OK");
    }

    private void help(String[] cmd) {
        if (cmd.length < 1) {
            this.con.sendResponse(501, "Missing parameters");
        }
        String command = cmd[0].toUpperCase();
        String help = cmd.length > 1 && command.equals("SITE") ? "SITE " + this.con.getSiteHelpMessage(cmd[1].toUpperCase()) : this.con.getHelpMessage(command);
        this.con.sendResponse(214, help);
    }

    private void type(String type) throws IOException {
        if ((type = type.toUpperCase()).startsWith("A")) {
            this.ascii = true;
        } else if (type.startsWith("L") || type.startsWith("I")) {
            this.ascii = false;
        } else {
            this.con.sendResponse(500, "Unknown type " + type);
            return;
        }
        this.con.sendResponse(200, "Type set to " + type);
    }

    private void stru(String structure) throws IOException {
        if (structure.equalsIgnoreCase("F")) {
            this.con.sendResponse(200, "The structure type was set to file");
        } else {
            this.con.sendResponse(504, "Unsupported structure type");
        }
    }

    private void mode(String mode) throws IOException {
        if (mode.equalsIgnoreCase("S")) {
            this.con.sendResponse(200, "The mode was set to stream");
        } else {
            this.con.sendResponse(504, "Unsupported mode");
        }
    }

    private void host(String host) throws IOException {
        if (this.authenticated) {
            this.con.sendResponse(503, "The user is already authenticated");
            return;
        }
        try {
            IUserAuthenticator auth = this.con.getServer().getAuthenticator();
            InetAddress address = InetAddress.getByName(host);
            if (auth.acceptsHost(this.con, address)) {
                this.address = address;
                this.con.sendResponse(220, "Host accepted");
            } else {
                this.address = null;
                this.con.sendResponse(504, "Host denied");
            }
        }
        catch (UnknownHostException ex) {
            this.con.sendResponse(501, "Invalid host");
        }
    }

    private void user(String username) throws IOException {
        if (this.authenticated) {
            this.con.sendResponse(230, "Logged in!");
            return;
        }
        this.username = username;
        IUserAuthenticator auth = this.con.getServer().getAuthenticator();
        if (auth.needsPassword(this.con, username, this.address)) {
            this.con.sendResponse(331, "Needs a password");
        } else {
            boolean success = this.authenticate(auth, null);
            if (success) {
                this.con.sendResponse(230, "Logged in!");
            } else {
                this.con.sendResponse(530, "Authentication failed");
                this.con.close();
            }
        }
    }

    private void pass(String password) throws IOException {
        if (this.authenticated) {
            this.con.sendResponse(230, "Logged in!");
            return;
        }
        boolean success = this.authenticate(this.con.getServer().getAuthenticator(), password);
        if (success) {
            this.con.sendResponse(230, "Logged in!");
        } else {
            this.con.sendResponse(530, "Authentication failed");
            this.con.close();
        }
    }

    private void acct(String info) {
        if (this.authenticated) {
            this.con.sendResponse(230, "Logged in!");
            return;
        }
        this.con.sendResponse(530, "Account information is not supported");
    }

    private void syst() {
        this.con.sendResponse(215, "UNIX Type: L8");
    }

    private void rein() {
        this.authenticated = false;
        this.username = null;
        this.address = null;
        this.con.sendResponse(220, "Ready for a new user");
    }

    private void quit() {
        this.con.sendResponse(221, "Closing connection...");
        this.stop = true;
    }

    private void pasv() throws IOException {
        FTPServer server = this.con.getServer();
        this.passiveServer = Utils.createServer(0, 5, server.getAddress(), server.getSSLContext(), this.secureData);
        this.passive = true;
        String host = this.passiveServer.getInetAddress().getHostAddress();
        int port = this.passiveServer.getLocalPort();
        if (host.equals("0.0.0.0")) {
            host = InetAddress.getLocalHost().getHostAddress();
        }
        String[] addr = host.split("\\.");
        String address = addr[0] + "," + addr[1] + "," + addr[2] + "," + addr[3];
        String addressPort = port / 256 + "," + port % 256;
        this.con.sendResponse(227, "Enabled Passive Mode (" + address + "," + addressPort + ")");
    }

    private void port(String data) {
        String[] args = data.split(",");
        this.activeHost = args[0] + "." + args[1] + "." + args[2] + "." + args[3];
        this.activePort = Integer.parseInt(args[4]) * 256 + Integer.parseInt(args[5]);
        this.passive = false;
        if (this.passiveServer != null) {
            Utils.closeQuietly(this.passiveServer);
            this.passiveServer = null;
        }
        this.con.sendResponse(200, "Enabled Active Mode");
    }

    private void stat() throws IOException {
        this.con.sendResponse(211, "Sending the status...");
        String ip = this.con.getAddress().getHostAddress();
        String user = this.username != null ? "as " + this.username : "anonymously";
        String type = this.ascii ? "ASCII" : "Binary";
        String data = "";
        data = data + "Connected from " + ip + " (" + ip + ")\r\n";
        data = data + "Logged in " + user + "\r\n";
        data = data + "TYPE: " + type + ", STRUcture: File, MODE: Stream\r\n";
        data = data + "Total bytes transferred for session: " + this.con.getBytesTransferred() + "\r\n";
        this.con.sendData(data.getBytes("UTF-8"));
        this.con.sendResponse(211, "Status sent!");
    }

    private void auth(String mechanism) throws IOException {
        if ((mechanism = mechanism.toUpperCase()).equals("TLS") || mechanism.equals("TLS-C") || mechanism.equals("SSL") || mechanism.equals("TLS-P")) {
            SSLContext ssl = this.con.getServer().getSSLContext();
            if (ssl == null) {
                this.con.sendResponse(431, "TLS/SSL is not available");
            } else if (this.con.isSSLEnabled()) {
                this.con.sendResponse(503, "TLS/SSL is already enabled");
            } else {
                this.con.sendResponse(234, "Enabling TLS/SSL...");
                this.con.enableSSL(ssl);
            }
        } else {
            this.con.sendResponse(502, "Unsupported mechanism");
        }
    }

    private void pbsz(String size) {
        if (this.con.isSSLEnabled()) {
            this.con.sendResponse(200, "The protection buffer size was set to 0");
        } else {
            this.con.sendResponse(503, "You can't set the protection buffer size in an insecure connection");
        }
    }

    private void prot(String level) {
        level = level.toUpperCase();
        if (!this.con.isSSLEnabled()) {
            this.con.sendResponse(503, "You can't update the protection level in an insecure connection");
        } else if (level.equals("C")) {
            this.secureData = false;
            this.con.sendResponse(200, "Protection level set to clear");
        } else if (level.equals("P")) {
            this.secureData = true;
            this.con.sendResponse(200, "Protection level set to private");
        } else if (level.equals("S") || level.equals("E")) {
            this.con.sendResponse(521, "Unsupported protection level");
        } else {
            this.con.sendResponse(502, "Unknown protection level");
        }
    }

    private void lpsv() throws IOException {
        FTPServer server = this.con.getServer();
        this.passiveServer = Utils.createServer(0, 5, server.getAddress(), server.getSSLContext(), this.secureData);
        this.passive = true;
        String host = this.passiveServer.getInetAddress().getHostAddress();
        int port = this.passiveServer.getLocalPort();
        if (host.equals("0.0.0.0")) {
            host = InetAddress.getLocalHost().getHostAddress();
        }
        String[] addr = host.split("\\.");
        String address = addr[0] + "," + addr[1] + "," + addr[2] + "," + addr[3];
        String addressPort = port / 256 + "," + port % 256;
        this.con.sendResponse(229, "Enabled Passive Mode (4,4," + address + ",2," + addressPort + ")");
    }

    private void lprt(String data) {
        String[] args = data.split(",");
        int hostLength = Integer.parseInt(args[1]);
        int portLength = Integer.parseInt(args[hostLength + 2]);
        String host = "";
        for (int i = 0; i < hostLength; ++i) {
            host = host + "." + args[i + 2];
        }
        this.activeHost = host.substring(1);
        int port = 0;
        for (int i = 0; i < portLength; ++i) {
            int num = Integer.parseInt(args[i + hostLength + 3]);
            int pos = (portLength - i - 1) * 8;
            port |= num << pos;
        }
        this.activePort = port;
        this.passive = false;
        if (this.passiveServer != null) {
            Utils.closeQuietly(this.passiveServer);
            this.passiveServer = null;
        }
        this.con.sendResponse(200, "Enabled Active Mode");
    }

    private void epsv() throws IOException {
        FTPServer server = this.con.getServer();
        this.passiveServer = Utils.createServer(0, 5, server.getAddress(), server.getSSLContext(), this.secureData);
        this.passive = true;
        this.con.sendResponse(229, "Enabled Passive Mode (|||" + this.passiveServer.getLocalPort() + "|)");
    }

    private void eprt(String data) {
        char delimiter = data.charAt(0);
        String[] args = data.split(String.format("\\%s", Character.valueOf(delimiter)));
        this.activeHost = args[2];
        this.activePort = Integer.parseInt(args[3]);
        this.passive = false;
        if (this.passiveServer != null) {
            Utils.closeQuietly(this.passiveServer);
            this.passiveServer = null;
        }
        this.con.sendResponse(200, "Enabled Active Mode");
    }

    private boolean authenticate(IUserAuthenticator auth, String password) {
        try {
            this.con.setFileSystem(auth.authenticate(this.con, this.address, this.username, password));
            this.authenticated = true;
            return true;
        }
        catch (IUserAuthenticator.AuthException ex) {
            return false;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }
}

