/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.eviction;

import com.hazelcast.cache.impl.eviction.EvictionConfiguration;
import com.hazelcast.cache.impl.eviction.EvictionPolicyEvaluator;
import com.hazelcast.cache.impl.eviction.EvictionPolicyType;
import com.hazelcast.cache.impl.eviction.impl.evaluator.LFUEvictionPolicyEvaluator;
import com.hazelcast.cache.impl.eviction.impl.evaluator.LRUEvictionPolicyEvaluator;
import java.util.HashMap;
import java.util.Map;

public final class EvictionPolicyEvaluatorProvider {
    private static final Map<EvictionPolicyType, EvictionPolicyEvaluator> EVICTION_POLICY_EVALUATOR_MAP = new HashMap<EvictionPolicyType, EvictionPolicyEvaluator>();

    private EvictionPolicyEvaluatorProvider() {
    }

    private static void init() {
        EVICTION_POLICY_EVALUATOR_MAP.put(EvictionPolicyType.LRU, new LRUEvictionPolicyEvaluator());
        EVICTION_POLICY_EVALUATOR_MAP.put(EvictionPolicyType.LFU, new LFUEvictionPolicyEvaluator());
    }

    public static EvictionPolicyEvaluator getEvictionPolicyEvaluator(EvictionConfiguration evictionConfig) {
        if (evictionConfig == null) {
            return null;
        }
        EvictionPolicyType evictionPolicyType = evictionConfig.getEvictionPolicyType();
        if (evictionPolicyType == null) {
            return null;
        }
        EvictionPolicyEvaluator evictionPolicyEvaluator = EVICTION_POLICY_EVALUATOR_MAP.get((Object)evictionPolicyType);
        if (evictionPolicyEvaluator != null) {
            return evictionPolicyEvaluator;
        }
        throw new IllegalArgumentException("Unsupported eviction policy type: " + (Object)((Object)evictionPolicyType));
    }

    static {
        EvictionPolicyEvaluatorProvider.init();
    }
}

