/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.impl.client.ClientRequest;
import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.core.IFunction;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.ringbuffer.OverflowPolicy;
import com.hazelcast.ringbuffer.ReadResultSet;
import com.hazelcast.ringbuffer.Ringbuffer;
import com.hazelcast.ringbuffer.impl.client.AddAllRequest;
import com.hazelcast.ringbuffer.impl.client.AddAsyncRequest;
import com.hazelcast.ringbuffer.impl.client.AddRequest;
import com.hazelcast.ringbuffer.impl.client.CapacityRequest;
import com.hazelcast.ringbuffer.impl.client.HeadSequenceRequest;
import com.hazelcast.ringbuffer.impl.client.ReadManyRequest;
import com.hazelcast.ringbuffer.impl.client.ReadOneRequest;
import com.hazelcast.ringbuffer.impl.client.RemainingCapacityRequest;
import com.hazelcast.ringbuffer.impl.client.SizeRequest;
import com.hazelcast.ringbuffer.impl.client.TailSequenceRequest;
import com.hazelcast.util.Preconditions;
import java.util.Collection;

public class ClientRingbufferProxy<E>
extends ClientProxy
implements Ringbuffer<E> {
    private volatile long capacity = -1L;
    private volatile int partitionId = -1;

    public ClientRingbufferProxy(String serviceName, String objectName) {
        super(serviceName, objectName);
    }

    private int getPartitionId() {
        if (this.partitionId == -1) {
            this.partitionId = this.getContext().getPartitionService().getPartitionId(this.getName());
        }
        return this.partitionId;
    }

    @Override
    public long capacity() {
        if (this.capacity == -1L) {
            CapacityRequest request = new CapacityRequest(this.getName());
            this.capacity = (Long)this.invokeOnPartition(request, this.getPartitionId());
        }
        return this.capacity;
    }

    @Override
    public long size() {
        SizeRequest request = new SizeRequest(this.getName());
        Long result = (Long)this.invokeOnPartition(request, this.getPartitionId());
        return result;
    }

    @Override
    public long tailSequence() {
        TailSequenceRequest request = new TailSequenceRequest(this.getName());
        Long result = (Long)this.invokeOnPartition(request, this.getPartitionId());
        return result;
    }

    @Override
    public long headSequence() {
        HeadSequenceRequest request = new HeadSequenceRequest(this.getName());
        Long result = (Long)this.invokeOnPartition(request, this.getPartitionId());
        return result;
    }

    @Override
    public long remainingCapacity() {
        RemainingCapacityRequest request = new RemainingCapacityRequest(this.getName());
        Long result = (Long)this.invokeOnPartition(request, this.getPartitionId());
        return result;
    }

    @Override
    public long add(E item) {
        Preconditions.checkNotNull(item, "item can't be null");
        AddRequest request = new AddRequest(this.getName(), this.toData(item));
        Long result = (Long)this.invokeOnPartition(request, this.getPartitionId());
        return result;
    }

    @Override
    public ICompletableFuture<Long> addAsync(E item, OverflowPolicy overflowPolicy) {
        Preconditions.checkNotNull(item, "item can't be null");
        Preconditions.checkNotNull(overflowPolicy, "overflowPolicy can't be null");
        AddAsyncRequest request = new AddAsyncRequest(this.getName(), this.toData(item), overflowPolicy);
        ClientInvocationFuture f = new ClientInvocation(this.getClient(), (ClientRequest)request, this.getPartitionId()).invoke();
        f.setResponseDeserialized(true);
        return f;
    }

    @Override
    public E readOne(long sequence) throws InterruptedException {
        ClientRingbufferProxy.checkSequence(sequence);
        ReadOneRequest request = new ReadOneRequest(this.getName(), sequence);
        Object result = this.invokeOnPartition(request, this.getPartitionId());
        return (E)result;
    }

    @Override
    public ICompletableFuture<Long> addAllAsync(Collection<? extends E> collection, OverflowPolicy overflowPolicy) {
        Preconditions.checkNotNull(collection, "collection can't be null");
        Preconditions.checkNotNull(overflowPolicy, "overflowPolicy can't be null");
        Preconditions.checkFalse(collection.isEmpty(), "collection can't be empty");
        Preconditions.checkTrue(collection.size() <= 1000, "collection can't be larger than 1000");
        AddAllRequest request = new AddAllRequest(this.getName(), this.toDataArray(collection), overflowPolicy);
        ClientInvocationFuture f = new ClientInvocation(this.getClient(), (ClientRequest)request, this.getPartitionId()).invoke();
        f.setResponseDeserialized(true);
        return f;
    }

    @Override
    public ICompletableFuture<ReadResultSet<E>> readManyAsync(long startSequence, int minCount, int maxCount, IFunction<E, Boolean> filter) {
        ClientRingbufferProxy.checkSequence(startSequence);
        Preconditions.checkNotNegative(minCount, "minCount can't be smaller than 0");
        Preconditions.checkTrue(maxCount >= minCount, "maxCount should be equal or larger than minCount");
        Preconditions.checkTrue((long)minCount <= this.capacity(), "the minCount should be smaller than or equal to the capacity");
        Preconditions.checkTrue(maxCount <= 1000, "maxCount can't be larger than 1000");
        ReadManyRequest request = new ReadManyRequest(this.getName(), startSequence, minCount, maxCount, this.toData(filter));
        ClientInvocationFuture f = new ClientInvocation(this.getClient(), (ClientRequest)request, this.getPartitionId()).invoke();
        f.setResponseDeserialized(true);
        return f;
    }

    private Data[] toDataArray(Collection<? extends E> collection) {
        Data[] items = new Data[collection.size()];
        int k = 0;
        for (E item : collection) {
            Preconditions.checkNotNull(item, "collection can't contains null items");
            items[k] = this.toData(item);
            ++k;
        }
        return items;
    }

    private static void checkSequence(long sequence) {
        if (sequence < 0L) {
            throw new IllegalArgumentException("sequence can't be smaller than 0, but was: " + sequence);
        }
    }
}

