/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.metrics.metricsets;

import com.hazelcast.internal.metrics.LongProbe;
import com.hazelcast.internal.metrics.MetricsRegistry;
import com.hazelcast.util.Preconditions;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.ManagementFactory;

public final class ClassLoadingMetricSet {
    private ClassLoadingMetricSet() {
    }

    public static void register(MetricsRegistry metricsRegistry) {
        Preconditions.checkNotNull(metricsRegistry, "metricsRegistry");
        ClassLoadingMXBean mxBean = ManagementFactory.getClassLoadingMXBean();
        metricsRegistry.register(mxBean, "classloading.loadedClassesCount", new LongProbe<ClassLoadingMXBean>(){

            @Override
            public long get(ClassLoadingMXBean classLoadingMXBean) {
                return classLoadingMXBean.getLoadedClassCount();
            }
        });
        metricsRegistry.register(mxBean, "classloading.totalLoadedClassesCount", new LongProbe<ClassLoadingMXBean>(){

            @Override
            public long get(ClassLoadingMXBean classLoadingMXBean) {
                return classLoadingMXBean.getTotalLoadedClassCount();
            }
        });
        metricsRegistry.register(mxBean, "classloading.unloadedClassCount", new LongProbe<ClassLoadingMXBean>(){

            @Override
            public long get(ClassLoadingMXBean classLoadingMXBean) {
                return classLoadingMXBean.getUnloadedClassCount();
            }
        });
    }
}

