/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl;

import com.hazelcast.config.MapConfig;
import com.hazelcast.config.PartitioningStrategyConfig;
import com.hazelcast.config.WanReplicationRef;
import com.hazelcast.core.IFunction;
import com.hazelcast.core.PartitioningStrategy;
import com.hazelcast.map.MapInterceptor;
import com.hazelcast.map.impl.ExpirationTimeSetter;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.SizeEstimator;
import com.hazelcast.map.impl.SizeEstimators;
import com.hazelcast.map.impl.mapstore.MapStoreContext;
import com.hazelcast.map.impl.mapstore.MapStoreContextFactory;
import com.hazelcast.map.impl.record.DataRecordFactory;
import com.hazelcast.map.impl.record.NativeRecordFactory;
import com.hazelcast.map.impl.record.ObjectRecordFactory;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.record.RecordFactory;
import com.hazelcast.map.merge.MapMergePolicy;
import com.hazelcast.nio.ClassLoaderUtil;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.query.impl.IndexService;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.wan.WanReplicationPublisher;
import com.hazelcast.wan.WanReplicationService;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class MapContainer {
    private final RecordFactory recordFactory;
    private final MapServiceContext mapServiceContext;
    private final List<MapInterceptor> interceptors;
    private final Map<String, MapInterceptor> interceptorMap;
    private final IndexService indexService = new IndexService();
    private final SizeEstimator nearCacheSizeEstimator;
    private final PartitioningStrategy partitioningStrategy;
    private final MapStoreContext mapStoreContext;
    private WanReplicationPublisher wanReplicationPublisher;
    private MapMergePolicy wanMergePolicy;
    private volatile MapConfig mapConfig;
    private final String name;
    private final String quorumName;
    private final IFunction<Object, Data> toDataFunction = new IFunction<Object, Data>(){

        @Override
        public Data apply(Object input) {
            SerializationService ss = MapContainer.this.mapStoreContext.getSerializationService();
            return ss.toData(input, MapContainer.this.partitioningStrategy);
        }
    };

    public MapContainer(String name, MapConfig mapConfig, MapServiceContext mapServiceContext) {
        this.name = name;
        this.mapConfig = mapConfig;
        this.mapServiceContext = mapServiceContext;
        this.partitioningStrategy = this.createPartitioningStrategy();
        this.quorumName = mapConfig.getQuorumName();
        NodeEngine nodeEngine = mapServiceContext.getNodeEngine();
        this.recordFactory = this.createRecordFactory(nodeEngine);
        this.initWanReplication(nodeEngine);
        this.interceptors = new CopyOnWriteArrayList<MapInterceptor>();
        this.interceptorMap = new ConcurrentHashMap<String, MapInterceptor>();
        this.nearCacheSizeEstimator = SizeEstimators.createNearCacheSizeEstimator();
        this.mapStoreContext = MapStoreContextFactory.createMapStoreContext(this);
        this.mapStoreContext.start();
    }

    private RecordFactory createRecordFactory(NodeEngine nodeEngine) {
        RecordFactory<Object> recordFactory;
        switch (this.mapConfig.getInMemoryFormat()) {
            case BINARY: {
                recordFactory = new DataRecordFactory(this.mapConfig, nodeEngine.getSerializationService(), this.partitioningStrategy);
                break;
            }
            case OBJECT: {
                recordFactory = new ObjectRecordFactory(this.mapConfig, nodeEngine.getSerializationService());
                break;
            }
            case NATIVE: {
                recordFactory = new NativeRecordFactory(this.mapConfig, nodeEngine.getOffHeapStorage(), nodeEngine.getSerializationService(), this.partitioningStrategy);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid storage format: " + (Object)((Object)this.mapConfig.getInMemoryFormat()));
            }
        }
        return recordFactory;
    }

    public void initWanReplication(NodeEngine nodeEngine) {
        WanReplicationRef wanReplicationRef = this.mapConfig.getWanReplicationRef();
        if (wanReplicationRef == null) {
            return;
        }
        String wanReplicationRefName = wanReplicationRef.getName();
        WanReplicationService wanReplicationService = nodeEngine.getWanReplicationService();
        this.wanReplicationPublisher = wanReplicationService.getWanReplicationPublisher(wanReplicationRefName);
        this.wanMergePolicy = this.mapServiceContext.getMergePolicyProvider().getMergePolicy(wanReplicationRef.getMergePolicy());
    }

    private PartitioningStrategy createPartitioningStrategy() {
        PartitioningStrategy strategy = null;
        PartitioningStrategyConfig partitioningStrategyConfig = this.mapConfig.getPartitioningStrategyConfig();
        if (partitioningStrategyConfig != null && (strategy = partitioningStrategyConfig.getPartitioningStrategy()) == null && partitioningStrategyConfig.getPartitioningStrategyClass() != null) {
            try {
                strategy = (PartitioningStrategy)ClassLoaderUtil.newInstance(this.mapServiceContext.getNodeEngine().getConfigClassLoader(), partitioningStrategyConfig.getPartitioningStrategyClass());
            }
            catch (Exception e) {
                throw ExceptionUtil.rethrow(e);
            }
        }
        return strategy;
    }

    public IndexService getIndexService() {
        return this.indexService;
    }

    public WanReplicationPublisher getWanReplicationPublisher() {
        return this.wanReplicationPublisher;
    }

    public MapMergePolicy getWanMergePolicy() {
        return this.wanMergePolicy;
    }

    public void addInterceptor(String id, MapInterceptor interceptor) {
        this.removeInterceptor(id);
        this.interceptorMap.put(id, interceptor);
        this.interceptors.add(interceptor);
    }

    public List<MapInterceptor> getInterceptors() {
        return this.interceptors;
    }

    public Map<String, MapInterceptor> getInterceptorMap() {
        return this.interceptorMap;
    }

    public void removeInterceptor(String id) {
        MapInterceptor interceptor = this.interceptorMap.remove(id);
        this.interceptors.remove(interceptor);
    }

    public Record createRecord(Data key, Object value, long ttlMillis, long now) {
        Record record = this.getRecordFactory().newRecord(key, value);
        record.setLastAccessTime(now);
        record.setLastUpdateTime(now);
        record.setCreationTime(now);
        long ttlMillisFromConfig = ExpirationTimeSetter.calculateTTLMillis(this.mapConfig);
        long ttl = ExpirationTimeSetter.pickTTL(ttlMillis, ttlMillisFromConfig);
        record.setTtl(ttl);
        long maxIdleMillis = ExpirationTimeSetter.calculateMaxIdleMillis(this.mapConfig);
        ExpirationTimeSetter.setExpirationTime(record, maxIdleMillis);
        return record;
    }

    public boolean isNearCacheEnabled() {
        return this.mapConfig.isNearCacheEnabled();
    }

    public int getTotalBackupCount() {
        return this.getBackupCount() + this.getAsyncBackupCount();
    }

    public int getBackupCount() {
        return this.mapConfig.getBackupCount();
    }

    public int getAsyncBackupCount() {
        return this.mapConfig.getAsyncBackupCount();
    }

    public PartitioningStrategy getPartitioningStrategy() {
        return this.partitioningStrategy;
    }

    public SizeEstimator getNearCacheSizeEstimator() {
        return this.nearCacheSizeEstimator;
    }

    public RecordFactory getRecordFactory() {
        return this.recordFactory;
    }

    public MapServiceContext getMapServiceContext() {
        return this.mapServiceContext;
    }

    public MapStoreContext getMapStoreContext() {
        return this.mapStoreContext;
    }

    public MapConfig getMapConfig() {
        return this.mapConfig;
    }

    public void setMapConfig(MapConfig mapConfig) {
        this.mapConfig = mapConfig;
    }

    public String getName() {
        return this.name;
    }

    public String getQuorumName() {
        return this.quorumName;
    }

    public IFunction<Object, Data> toData() {
        return this.toDataFunction;
    }
}

