/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.mapstore.writebehind;

import com.hazelcast.map.impl.mapstore.writebehind.BoundedWriteBehindQueue;
import com.hazelcast.map.impl.mapstore.writebehind.CoalescedWriteBehindQueue;
import com.hazelcast.map.impl.mapstore.writebehind.CyclicWriteBehindQueue;
import com.hazelcast.map.impl.mapstore.writebehind.SynchronizedWriteBehindQueue;
import com.hazelcast.map.impl.mapstore.writebehind.WriteBehindQueue;
import java.util.concurrent.atomic.AtomicInteger;

public final class WriteBehindQueues {
    private WriteBehindQueues() {
    }

    public static WriteBehindQueue createBoundedWriteBehindQueue(int maxCapacity, AtomicInteger counter) {
        WriteBehindQueue queue = WriteBehindQueues.createCyclicWriteBehindQueue();
        WriteBehindQueue boundedQueue = WriteBehindQueues.createBoundedWriteBehindQueue(maxCapacity, counter, queue);
        return WriteBehindQueues.createSynchronizedWriteBehindQueue(boundedQueue);
    }

    public static <T> WriteBehindQueue<T> createDefaultWriteBehindQueue() {
        WriteBehindQueue queue = WriteBehindQueues.createCoalescedWriteBehindQueue();
        return WriteBehindQueues.createSynchronizedWriteBehindQueue(queue);
    }

    private static WriteBehindQueue createSynchronizedWriteBehindQueue(WriteBehindQueue queue) {
        return new SynchronizedWriteBehindQueue(queue);
    }

    private static WriteBehindQueue createCoalescedWriteBehindQueue() {
        return new CoalescedWriteBehindQueue();
    }

    private static WriteBehindQueue createCyclicWriteBehindQueue() {
        return new CyclicWriteBehindQueue();
    }

    private static WriteBehindQueue createBoundedWriteBehindQueue(int maxCapacity, AtomicInteger counter, WriteBehindQueue queue) {
        return new BoundedWriteBehindQueue(maxCapacity, counter, queue);
    }
}

