/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.record;

import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.MapConfig;
import com.hazelcast.core.PartitioningStrategy;
import com.hazelcast.map.impl.record.CachedDataRecord;
import com.hazelcast.map.impl.record.CachedDataRecordWithStats;
import com.hazelcast.map.impl.record.DataRecord;
import com.hazelcast.map.impl.record.DataRecordWithStats;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.record.RecordFactory;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.SerializationService;

public class DataRecordFactory
implements RecordFactory<Data> {
    private final SerializationService serializationService;
    private final PartitioningStrategy partitionStrategy;
    private final boolean optimizeQuery;
    private final boolean statisticsEnabled;

    public DataRecordFactory(MapConfig config, SerializationService serializationService, PartitioningStrategy partitionStrategy) {
        this.serializationService = serializationService;
        this.partitionStrategy = partitionStrategy;
        this.statisticsEnabled = config.isStatisticsEnabled();
        this.optimizeQuery = config.isOptimizeQueries();
    }

    @Override
    public InMemoryFormat getStorageFormat() {
        return InMemoryFormat.BINARY;
    }

    @Override
    public Record<Data> newRecord(Data key, Object value) {
        Object data = this.serializationService.toData(value, this.partitionStrategy);
        if (this.optimizeQuery) {
            return this.statisticsEnabled ? new CachedDataRecordWithStats(key, (Data)data) : new CachedDataRecord(key, (Data)data);
        }
        return this.statisticsEnabled ? new DataRecordWithStats(key, (Data)data) : new DataRecord(key, (Data)data);
    }

    @Override
    public void setValue(Record<Data> record, Object value) {
        Data v = value instanceof Data ? (Data)value : this.serializationService.toData(value, this.partitionStrategy);
        record.setValue(v);
    }

    @Override
    public boolean isEquals(Object value1, Object value2) {
        return this.serializationService.toData(value1).equals(this.serializationService.toData(value2));
    }
}

