/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query.impl;

import com.hazelcast.nio.serialization.Data;
import com.hazelcast.query.impl.QueryableEntry;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;

public class MultiResultSet
extends AbstractSet<QueryableEntry> {
    private Set<Object> index;
    private final List<ConcurrentMap<Data, QueryableEntry>> resultSets = new ArrayList<ConcurrentMap<Data, QueryableEntry>>();

    public void addResultSet(ConcurrentMap<Data, QueryableEntry> resultSet) {
        this.resultSets.add(resultSet);
    }

    @Override
    public boolean contains(Object o) {
        QueryableEntry entry = (QueryableEntry)o;
        if (this.index != null) {
            return this.checkFromIndex(entry);
        }
        if (this.resultSets.size() > 3) {
            this.index = new HashSet<Object>();
            for (ConcurrentMap<Data, QueryableEntry> result : this.resultSets) {
                for (QueryableEntry queryableEntry : result.values()) {
                    this.index.add(queryableEntry.getIndexKey());
                }
            }
            return this.checkFromIndex(entry);
        }
        for (ConcurrentMap<Data, QueryableEntry> resultSet : this.resultSets) {
            if (!resultSet.containsKey(entry.getIndexKey())) continue;
            return true;
        }
        return false;
    }

    private boolean checkFromIndex(QueryableEntry entry) {
        return this.index.contains(entry.getIndexKey());
    }

    @Override
    public Iterator<QueryableEntry> iterator() {
        return new It();
    }

    @Override
    public boolean add(QueryableEntry obj) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        int size = 0;
        for (ConcurrentMap<Data, QueryableEntry> resultSet : this.resultSets) {
            size += resultSet.size();
        }
        return size;
    }

    class It
    implements Iterator<QueryableEntry> {
        int currentIndex;
        Iterator<QueryableEntry> currentIterator;

        It() {
        }

        @Override
        public boolean hasNext() {
            if (MultiResultSet.this.resultSets.size() == 0) {
                return false;
            }
            if (this.currentIterator != null && this.currentIterator.hasNext()) {
                return true;
            }
            while (this.currentIndex < MultiResultSet.this.resultSets.size()) {
                this.currentIterator = ((ConcurrentMap)MultiResultSet.this.resultSets.get(this.currentIndex++)).values().iterator();
                if (!this.currentIterator.hasNext()) continue;
                return true;
            }
            return false;
        }

        @Override
        public QueryableEntry next() {
            if (MultiResultSet.this.resultSets.size() == 0) {
                return null;
            }
            return this.currentIterator.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

