/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.web.entryprocessor;

import com.hazelcast.map.EntryBackupProcessor;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.web.JvmIdAware;
import com.hazelcast.web.SessionState;
import com.hazelcast.web.WebDataSerializerHook;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class SessionUpdateEntryProcessor
implements EntryProcessor<String, SessionState>,
EntryBackupProcessor<String, SessionState>,
IdentifiedDataSerializable,
JvmIdAware {
    private Map<String, Data> attributes;
    private String jvmId;

    public SessionUpdateEntryProcessor(int size) {
        this.attributes = new HashMap<String, Data>(size);
    }

    public SessionUpdateEntryProcessor(String key, Data value) {
        this.attributes = new HashMap<String, Data>(1);
        this.attributes.put(key, value);
    }

    public SessionUpdateEntryProcessor() {
        this.attributes = Collections.emptyMap();
    }

    public Map<String, Data> getAttributes() {
        return this.attributes;
    }

    public String getJvmId() {
        return this.jvmId;
    }

    @Override
    public void setJvmId(String jvmId) {
        this.jvmId = jvmId;
    }

    @Override
    public int getFactoryId() {
        return WebDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 1;
    }

    @Override
    public Object process(Map.Entry<String, SessionState> entry) {
        SessionState sessionState = entry.getValue();
        if (sessionState == null) {
            sessionState = new SessionState();
        }
        sessionState.addJvmId(this.jvmId);
        for (Map.Entry<String, Data> attribute : this.attributes.entrySet()) {
            String name = attribute.getKey();
            Data value = attribute.getValue();
            if (value == null) {
                sessionState.getAttributes().remove(name);
                continue;
            }
            sessionState.getAttributes().put(name, value);
        }
        entry.setValue(sessionState);
        return Boolean.TRUE;
    }

    @Override
    public EntryBackupProcessor<String, SessionState> getBackupProcessor() {
        return this;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.jvmId);
        out.writeInt(this.attributes.size());
        for (Map.Entry<String, Data> entry : this.attributes.entrySet()) {
            out.writeUTF(entry.getKey());
            out.writeData(entry.getValue());
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.jvmId = in.readUTF();
        int attCount = in.readInt();
        this.attributes = new HashMap<String, Data>(attCount);
        for (int i = 0; i < attCount; ++i) {
            this.attributes.put(in.readUTF(), in.readData());
        }
    }

    @Override
    public void processBackup(Map.Entry<String, SessionState> entry) {
        this.process(entry);
    }
}

