/*
 * Decompiled with CFR 0.152.
 */
package com.helger.collection.enumeration;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.array.ArrayHelper;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Enumeration;
import java.util.NoSuchElementException;

@NotThreadSafe
public class ArrayEnumeration<ELEMENTTYPE>
implements Enumeration<ELEMENTTYPE> {
    private ELEMENTTYPE[] m_aArray;
    private int m_nIndex;

    @SafeVarargs
    public ArrayEnumeration(ELEMENTTYPE ... ELEMENTTYPEArray) {
        this(ELEMENTTYPEArray, 0, ELEMENTTYPEArray.length);
    }

    public ArrayEnumeration(@Nonnull ELEMENTTYPE[] ELEMENTTYPEArray, @Nonnegative int n, @Nonnegative int n2) {
        ValueEnforcer.notNull(ELEMENTTYPEArray, (String)"Array");
        ValueEnforcer.isGE0((int)n, (String)"StartIndex");
        ValueEnforcer.isGE0((int)n2, (String)"Length");
        this.m_nIndex = 0;
        this.m_aArray = ArrayHelper.getCopy((Object[])ELEMENTTYPEArray, (int)n, (int)n2);
    }

    @Nonnegative
    protected final int getIndex() {
        return this.m_nIndex;
    }

    @Nullable
    protected final ELEMENTTYPE get(@Nonnegative int n) {
        return this.m_aArray[n];
    }

    @Nonnegative
    protected final int getCount() {
        return this.m_aArray.length;
    }

    @Override
    public boolean hasMoreElements() {
        return this.m_nIndex < this.m_aArray.length;
    }

    @Override
    @Nullable
    public ELEMENTTYPE nextElement() {
        if (!this.hasMoreElements()) {
            throw new NoSuchElementException();
        }
        ELEMENTTYPE ELEMENTTYPE = this.m_aArray[this.m_nIndex];
        ++this.m_nIndex;
        return ELEMENTTYPE;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        ArrayEnumeration arrayEnumeration = (ArrayEnumeration)object;
        ELEMENTTYPE[] ELEMENTTYPEArray = this.m_aArray;
        return EqualsHelper.equals(ELEMENTTYPEArray, arrayEnumeration.m_aArray) && this.m_nIndex == arrayEnumeration.m_nIndex;
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object[])this.m_aArray).append(this.m_nIndex).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("array", (Object[])this.m_aArray).append("index", this.m_nIndex).getToString();
    }
}

