/*
 * Decompiled with CFR 0.152.
 */
package com.helger.collection.hierarchy;

import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.collection.commons.ICommonsCollection;
import com.helger.collection.commons.ICommonsList;
import com.helger.collection.hierarchy.IChildrenProvider;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Comparator;

@Immutable
public class ChildrenProviderSorting<CHILDTYPE>
implements IChildrenProvider<CHILDTYPE> {
    private final IChildrenProvider<CHILDTYPE> m_aChildrenProvider;
    private final Comparator<? super CHILDTYPE> m_aComparator;

    public ChildrenProviderSorting(@Nonnull IChildrenProvider<CHILDTYPE> iChildrenProvider, @Nonnull Comparator<? super CHILDTYPE> comparator) {
        this.m_aChildrenProvider = (IChildrenProvider)ValueEnforcer.notNull(iChildrenProvider, (String)"ChildrenProvider");
        this.m_aComparator = (Comparator)ValueEnforcer.notNull(comparator, (String)"Comparator");
    }

    @Nonnull
    public IChildrenProvider<CHILDTYPE> getChildrenProvider() {
        return this.m_aChildrenProvider;
    }

    @Nonnull
    public Comparator<? super CHILDTYPE> getComparator() {
        return this.m_aComparator;
    }

    @Override
    public final boolean hasChildren(@Nullable CHILDTYPE CHILDTYPE) {
        return this.m_aChildrenProvider.hasChildren(CHILDTYPE);
    }

    @Override
    public final int getChildCount(@Nullable CHILDTYPE CHILDTYPE) {
        return this.m_aChildrenProvider.getChildCount(CHILDTYPE);
    }

    @Override
    @Nullable
    public ICommonsList<? extends CHILDTYPE> getAllChildren(@Nullable CHILDTYPE CHILDTYPE) {
        ICommonsCollection<CHILDTYPE> iCommonsCollection = this.m_aChildrenProvider.getAllChildren(CHILDTYPE);
        return iCommonsCollection == null ? null : iCommonsCollection.getSorted(this.m_aComparator);
    }
}

