/*
 * Decompiled with CFR 0.152.
 */
package com.helger.collection.hierarchy;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.state.EContinue;
import com.helger.collection.commons.ICommonsCollection;
import com.helger.collection.commons.ICommonsIterable;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

public interface IHasChildren<CHILDTYPE> {
    default public boolean hasChildren() {
        return this.getChildCount() > 0;
    }

    default public boolean hasNoChildren() {
        return !this.hasChildren();
    }

    @Nonnegative
    public int getChildCount();

    @Nullable
    @ReturnsMutableCopy
    public ICommonsCollection<? extends CHILDTYPE> getAllChildren();

    @Nullable
    public ICommonsIterable<? extends CHILDTYPE> getChildren();

    default public void forAllChildren(@Nonnull Consumer<? super CHILDTYPE> consumer) {
        if (this.hasChildren()) {
            this.getChildren().forEach(consumer);
        }
    }

    @Nonnull
    default public EContinue forAllChildrenBreakable(@Nonnull Function<? super CHILDTYPE, EContinue> function) {
        if (this.hasChildren()) {
            return this.getChildren().forEachBreakable(function);
        }
        return EContinue.CONTINUE;
    }

    default public void forAllChildren(@Nonnull Predicate<? super CHILDTYPE> predicate, @Nonnull Consumer<? super CHILDTYPE> consumer) {
        if (this.hasChildren()) {
            this.getChildren().findAll(predicate, consumer);
        }
    }

    default public <DSTTYPE> void forAllChildrenMapped(@Nonnull Predicate<? super CHILDTYPE> predicate, @Nonnull Function<? super CHILDTYPE, ? extends DSTTYPE> function, @Nonnull Consumer<? super DSTTYPE> consumer) {
        if (this.hasChildren()) {
            this.getChildren().findAllMapped(predicate, function, consumer);
        }
    }
}

