/*
 * Decompiled with CFR 0.152.
 */
package com.helger.collection.iterator;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.array.ArrayHelper;
import com.helger.collection.CollectionHelper;
import com.helger.collection.base.EmptyIterator;
import com.helger.collection.base.IIterableIterator;
import com.helger.collection.commons.CommonsIterableEnumeration;
import com.helger.collection.iterator.ArrayIterator;
import com.helger.collection.iterator.CombinedIterator;
import com.helger.collection.iterator.ReverseListIterator;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;

@Immutable
public class IteratorHelper {
    protected IteratorHelper() {
    }

    public static boolean isEmpty(@Nullable Iterator<?> iterator) {
        return iterator == null || !iterator.hasNext();
    }

    public static boolean isNotEmpty(@Nullable Iterator<?> iterator) {
        return iterator != null && iterator.hasNext();
    }

    @Nonnegative
    public static int getSize(@Nullable Iterator<?> iterator) {
        return CollectionHelper.getSizeIterator(iterator);
    }

    @Nonnull
    public static <ELEMENTTYPE> Iterator<ELEMENTTYPE> getIterator(@Nullable Iterable<ELEMENTTYPE> iterable) {
        return iterable == null ? new EmptyIterator() : IteratorHelper.getIterator(iterable.iterator());
    }

    @Nonnull
    public static <ELEMENTTYPE> Iterator<ELEMENTTYPE> getIterator(@Nullable Iterator<ELEMENTTYPE> emptyIterator) {
        return emptyIterator == null ? new EmptyIterator() : emptyIterator;
    }

    @Nonnull
    public static <ELEMENTTYPE> IIterableIterator<ELEMENTTYPE> getIterator(@Nullable Enumeration<? extends ELEMENTTYPE> enumeration) {
        return new CommonsIterableEnumeration<ELEMENTTYPE>(enumeration);
    }

    @Nonnull
    @SafeVarargs
    public static <ELEMENTTYPE> Iterator<ELEMENTTYPE> getIterator(ELEMENTTYPE ... ELEMENTTYPEArray) {
        return ArrayHelper.isEmpty((Object[])ELEMENTTYPEArray) ? new EmptyIterator() : new ArrayIterator<ELEMENTTYPE>(ELEMENTTYPEArray);
    }

    @Nonnull
    public static <ELEMENTTYPE> Iterator<ELEMENTTYPE> getReverseIterator(@Nullable List<? extends ELEMENTTYPE> list) {
        if (CollectionHelper.isEmpty(list)) {
            return new EmptyIterator();
        }
        return new ReverseListIterator<ELEMENTTYPE>(list);
    }

    @Nonnull
    public static <ELEMENTTYPE> Iterator<ELEMENTTYPE> getCombinedIterator(@Nullable Iterator<? extends ELEMENTTYPE> iterator, @Nullable Iterator<? extends ELEMENTTYPE> iterator2) {
        return new CombinedIterator<ELEMENTTYPE>(iterator, iterator2);
    }
}

