/*
 * Decompiled with CFR 0.152.
 */
package com.helger.collection.vector;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.array.ArrayHelper;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.collection.CollectionHelper;
import com.helger.collection.commons.CommonsVector;
import com.helger.collection.commons.ICommonsIterableIterator;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Predicate;

@Immutable
public final class VectorHelper {
    private VectorHelper() {
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsVector<ELEMENTTYPE> newVector(@Nonnegative int n) {
        return new CommonsVector<int>(n);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsVector<ELEMENTTYPE> newVector() {
        return new CommonsVector();
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <SRCTYPE, DSTTYPE> CommonsVector<DSTTYPE> newVectorMapped(@Nullable Collection<? extends SRCTYPE> collection, @Nonnull Function<? super SRCTYPE, DSTTYPE> function) {
        if (CollectionHelper.isEmpty(collection)) {
            return VectorHelper.newVector(false);
        }
        CommonsVector<int> commonsVector = VectorHelper.newVector(collection.size());
        commonsVector.addAllMapped(collection, function);
        return commonsVector;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <SRCTYPE, DSTTYPE> CommonsVector<DSTTYPE> newVectorMapped(@Nullable SRCTYPE[] SRCTYPEArray, @Nonnull Function<? super SRCTYPE, DSTTYPE> function) {
        if (ArrayHelper.isEmpty((Object[])SRCTYPEArray)) {
            return VectorHelper.newVector(false);
        }
        CommonsVector<int> commonsVector = VectorHelper.newVector(SRCTYPEArray.length);
        commonsVector.addAllMapped(SRCTYPEArray, function);
        return commonsVector;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsVector<ELEMENTTYPE> newVector(@Nullable Collection<? extends ELEMENTTYPE> collection, @Nonnull Predicate<? super ELEMENTTYPE> predicate) {
        if (CollectionHelper.isEmpty(collection)) {
            return VectorHelper.newVector(false);
        }
        CommonsVector<int> commonsVector = VectorHelper.newVector(collection.size());
        commonsVector.addAll((Iterable<int>)collection, (Predicate<int>)predicate);
        return commonsVector;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsVector<ELEMENTTYPE> newVectorPrefilled(@Nullable ELEMENTTYPE ELEMENTTYPE, @Nonnegative int n) {
        ValueEnforcer.isGE0((int)n, (String)"Elements");
        CommonsVector<int> commonsVector = VectorHelper.newVector(n);
        for (int i = 0; i < n; ++i) {
            commonsVector.add(ELEMENTTYPE);
        }
        return commonsVector;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsVector<ELEMENTTYPE> newVector(@Nullable ELEMENTTYPE ELEMENTTYPE) {
        return new CommonsVector<ELEMENTTYPE>(ELEMENTTYPE);
    }

    @Nonnull
    @SafeVarargs
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsVector<ELEMENTTYPE> newVector(ELEMENTTYPE ... ELEMENTTYPEArray) {
        if (ArrayHelper.isEmpty((Object[])ELEMENTTYPEArray)) {
            return VectorHelper.newVector(false);
        }
        return new CommonsVector<ELEMENTTYPE>(ELEMENTTYPEArray);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsVector<ELEMENTTYPE> newVector(@Nullable Enumeration<? extends ELEMENTTYPE> enumeration) {
        CommonsVector<? extends ELEMENTTYPE> commonsVector = VectorHelper.newVector();
        commonsVector.addAll(enumeration);
        return commonsVector;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsVector<ELEMENTTYPE> newVector(@Nullable Iterator<? extends ELEMENTTYPE> iterator) {
        CommonsVector<? extends ELEMENTTYPE> commonsVector = VectorHelper.newVector();
        commonsVector.addAll(iterator);
        return commonsVector;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsVector<ELEMENTTYPE> newVector(@Nullable Iterable<? extends ELEMENTTYPE> iterable) {
        CommonsVector<? extends ELEMENTTYPE> commonsVector = VectorHelper.newVector();
        commonsVector.addAll(iterable);
        return commonsVector;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsVector<ELEMENTTYPE> newVector(@Nullable Collection<? extends ELEMENTTYPE> collection) {
        if (CollectionHelper.isEmpty(collection)) {
            return VectorHelper.newVector(false);
        }
        return new CommonsVector<Collection<? extends ELEMENTTYPE>>(collection);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsVector<ELEMENTTYPE> newVector(@Nullable ICommonsIterableIterator<? extends ELEMENTTYPE> iCommonsIterableIterator) {
        if (iCommonsIterableIterator == null) {
            return VectorHelper.newVector(false);
        }
        return VectorHelper.newVector(iCommonsIterableIterator.iterator());
    }
}

