/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.csv;

import com.helger.base.enforce.ValueEnforcer;
import com.helger.collection.commons.ICommonsList;
import com.helger.commons.csv.CSVReader;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class CSVIterator
implements Iterator<ICommonsList<String>> {
    private final CSVReader m_aReader;
    private ICommonsList<String> m_aNextLine;

    public CSVIterator(@Nonnull CSVReader cSVReader) throws IOException {
        ValueEnforcer.notNull((Object)cSVReader, (String)"Reader");
        this.m_aReader = cSVReader;
        this.m_aNextLine = cSVReader.readNext();
    }

    @Override
    public boolean hasNext() {
        return this.m_aNextLine != null;
    }

    @Override
    @Nonnull
    public ICommonsList<String> next() {
        ICommonsList<String> iCommonsList = this.m_aNextLine;
        if (iCommonsList == null) {
            throw new NoSuchElementException();
        }
        try {
            this.m_aNextLine = this.m_aReader.readNext();
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Failed to read next CSV line", iOException);
        }
        return iCommonsList;
    }
}

