/*
 * Decompiled with CFR 0.152.
 */
package com.helger.dao.container;

import com.helger.annotation.OverridingMethodsMustInvokeSuper;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.base.concurrent.SimpleReadWriteLock;
import com.helger.collection.commons.ICommonsList;
import com.helger.dao.IDAO;
import com.helger.dao.container.IDAOContainer;

@ThreadSafe
public abstract class AbstractDAOContainer
implements IDAOContainer {
    protected final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();

    @Override
    @OverridingMethodsMustInvokeSuper
    public boolean isAutoSaveEnabled() {
        return this.m_aRWLock.readLockedBoolean(() -> this.containsAny(iDAO -> iDAO != null && iDAO.isAutoSaveEnabled()));
    }

    @Override
    public final void beginWithoutAutoSave() {
        ICommonsList<IDAO> iCommonsList = this.getAllContainedDAOs();
        this.m_aRWLock.writeLocked(() -> {
            for (IDAO iDAO : iCommonsList) {
                if (iDAO == null) continue;
                iDAO.beginWithoutAutoSave();
            }
        });
    }

    @Override
    public final void endWithoutAutoSave() {
        ICommonsList<IDAO> iCommonsList = this.getAllContainedDAOs();
        this.m_aRWLock.writeLocked(() -> {
            for (IDAO iDAO : iCommonsList) {
                if (iDAO == null) continue;
                iDAO.endWithoutAutoSave();
            }
        });
    }
}

