/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jaxb;

import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.base.log.ConditionalLogger;
import com.helger.base.log.IConditionalLogger;
import com.helger.base.log.IHasConditionalLogger;
import com.helger.cache.impl.Cache;
import com.helger.jaxb.JAXBContextCacheKey;
import jakarta.annotation.Nonnull;
import jakarta.xml.bind.JAXBContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class JAXBContextCache
extends Cache<JAXBContextCacheKey, JAXBContext>
implements IHasConditionalLogger {
    private static final Logger LOGGER = LoggerFactory.getLogger(JAXBContextCache.class);
    private static final ConditionalLogger CONDLOG = new ConditionalLogger(LOGGER);
    private static boolean s_bDefaultInstantiated = false;

    public static boolean isSilentMode() {
        return CONDLOG.isDisabled();
    }

    public static boolean setSilentMode(boolean bl) {
        return !CONDLOG.setEnabled(!bl);
    }

    private JAXBContextCache() {
        super(jAXBContextCacheKey -> jAXBContextCacheKey.createJAXBContext((IConditionalLogger)CONDLOG), 1000, JAXBContextCache.class.getName());
    }

    public static boolean isInstantiated() {
        return s_bDefaultInstantiated;
    }

    @Nonnull
    public static JAXBContextCache getInstance() {
        JAXBContextCache jAXBContextCache = SingletonHolder.INSTANCE;
        s_bDefaultInstantiated = true;
        return jAXBContextCache;
    }

    private static final class SingletonHolder {
        static final JAXBContextCache INSTANCE = new JAXBContextCache();

        private SingletonHolder() {
        }
    }
}

