/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jaxb.validation;

import com.helger.annotation.concurrent.GuardedBy;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.concurrent.SimpleReadWriteLock;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.state.EChange;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.diagnostics.error.IError;
import com.helger.diagnostics.error.list.ErrorList;
import com.helger.diagnostics.error.list.IErrorList;
import com.helger.jaxb.validation.AbstractValidationEventHandler;
import jakarta.annotation.Nonnull;
import java.util.function.Consumer;

@ThreadSafe
public class CollectingValidationEventHandler
extends AbstractValidationEventHandler {
    protected final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    private final ErrorList m_aErrors = new ErrorList();

    @Override
    protected void onEvent(@Nonnull IError iError) {
        this.m_aRWLock.writeLockedBoolean(() -> this.m_aErrors.add((Object)iError));
    }

    @Nonnull
    @ReturnsMutableCopy
    public IErrorList getErrorList() {
        return (IErrorList)this.m_aRWLock.readLockedGet(() -> ((ErrorList)this.m_aErrors).getClone());
    }

    public void forEachResourceError(@Nonnull Consumer<? super IError> consumer) {
        ValueEnforcer.notNull(consumer, (String)"Consumer");
        this.m_aRWLock.readLocked(() -> this.m_aErrors.forEach(consumer));
    }

    @Nonnull
    public EChange clearResourceErrors() {
        return (EChange)this.m_aRWLock.writeLockedGet(() -> ((ErrorList)this.m_aErrors).removeAll());
    }

    @Override
    public String toString() {
        return (String)this.m_aRWLock.readLockedGet(() -> ToStringGenerator.getDerived((String)super.toString()).append("Errors", (Object)this.m_aErrors).getToString());
    }
}

