/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.serialize.read;

import com.helger.commons.exception.InitializationException;
import com.helger.xml.XMLFactory;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public final class SAXReaderFactory
implements Supplier<XMLReader> {
    @Override
    @Nonnull
    public XMLReader get() {
        return SAXReaderFactory.createXMLReader();
    }

    @Nonnull
    public static XMLReader createXMLReader() {
        SAXParserFactory sAXParserFactory = XMLFactory.createDefaultSAXParserFactory();
        return SAXReaderFactory.createXMLReader(sAXParserFactory);
    }

    @Nonnull
    public static XMLReader createXMLReader(@Nonnull SAXParserFactory sAXParserFactory) {
        try {
            return sAXParserFactory.newSAXParser().getXMLReader();
        }
        catch (ParserConfigurationException | SAXException exception) {
            throw new InitializationException("Failed to instantiate XML SAX reader", (Throwable)exception);
        }
    }
}

