/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.transform;

import com.helger.base.location.ILocation;
import com.helger.base.location.SimpleLocation;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.diagnostics.error.IError;
import com.helger.diagnostics.error.SingleError;
import com.helger.diagnostics.error.SingleErrorBuilder;
import com.helger.diagnostics.error.level.EErrorLevel;
import com.helger.diagnostics.error.level.IErrorLevel;
import com.helger.text.IMultilingualText;
import com.helger.xml.transform.EXMLTransformTexts;
import com.helger.xml.transform.ITransformErrorListener;
import jakarta.annotation.Nonnull;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;

public abstract class AbstractTransformErrorListener
implements ITransformErrorListener {
    protected AbstractTransformErrorListener() {
    }

    @Nonnull
    private static IError _buildError(@Nonnull TransformerException transformerException, @Nonnull IErrorLevel iErrorLevel, @Nonnull IMultilingualText iMultilingualText) {
        SimpleLocation simpleLocation = SimpleLocation.create((SourceLocator)transformerException.getLocator());
        return ((SingleErrorBuilder)((SingleErrorBuilder)((SingleErrorBuilder)((SingleErrorBuilder)SingleError.builder().errorLevel(iErrorLevel)).errorLocation((ILocation)simpleLocation)).errorText(iMultilingualText)).linkedException((Throwable)transformerException)).build();
    }

    protected abstract void internalLog(@Nonnull IError var1);

    @Override
    public final void warning(@Nonnull TransformerException transformerException) throws TransformerException {
        this.internalLog(AbstractTransformErrorListener._buildError(transformerException, (IErrorLevel)EErrorLevel.WARN, EXMLTransformTexts.TRANSFORMATION_WARNING.getAsMLT()));
    }

    @Override
    public final void error(@Nonnull TransformerException transformerException) throws TransformerException {
        this.internalLog(AbstractTransformErrorListener._buildError(transformerException, (IErrorLevel)EErrorLevel.ERROR, EXMLTransformTexts.TRANSFORMATION_ERROR.getAsMLT()));
    }

    @Override
    public final void fatalError(@Nonnull TransformerException transformerException) throws TransformerException {
        this.internalLog(AbstractTransformErrorListener._buildError(transformerException, (IErrorLevel)EErrorLevel.FATAL_ERROR, EXMLTransformTexts.TRANSFORMATION_FATAL_ERROR.getAsMLT()));
    }

    public String toString() {
        return new ToStringGenerator((Object)this).getToString();
    }
}

