/*
 * Decompiled with CFR 0.152.
 */
package com.helger.diver.api.settings;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.enforce.ValueEnforcer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class DVRGlobalCoordinateSettings {
    public static final int DEFAULT_MIN_LEN = 1;
    public static final int DEFAULT_GROUP_ID_MAX_LEN = 64;
    public static final int DEFAULT_ARTIFACT_ID_MAX_LEN = 64;
    public static final int DEFAULT_VERSION_MAX_LEN = 64;
    public static final int DEFAULT_CLASSIFIER_MAX_LEN = 64;
    private static final Logger LOGGER = LoggerFactory.getLogger(DVRGlobalCoordinateSettings.class);
    private static int s_nGroupIDMinLen = 1;
    private static int s_nGroupIDMaxLen = 64;
    private static int s_nArtifactIDMinLen = 1;
    private static int s_nArtifactIDMaxLen = 64;
    private static int s_nVersionMinLen = 1;
    private static int s_nVersionMaxLen = 64;
    private static int s_nClassifierMinLen = 1;
    private static int s_nClassifierMaxLen = 64;

    private DVRGlobalCoordinateSettings() {
    }

    @Nonnegative
    public static int getGroupIDMinLen() {
        return s_nGroupIDMinLen;
    }

    @Nonnegative
    public static int getGroupIDMaxLen() {
        return s_nGroupIDMaxLen;
    }

    public static void setGroupIDMaxLen(@Nonnegative int n) {
        ValueEnforcer.isGT0((int)n, (String)"MaxLen");
        if (n != s_nGroupIDMaxLen) {
            LOGGER.warn("Changed the maximum group ID length of DVR Coordinate from " + s_nGroupIDMaxLen + " to " + n);
            s_nGroupIDMaxLen = n;
        }
    }

    @Nonnegative
    public static int getArtifactIDMinLen() {
        return s_nArtifactIDMinLen;
    }

    @Nonnegative
    public static int getArtifactIDMaxLen() {
        return s_nArtifactIDMaxLen;
    }

    public static void setArtifactIDMaxLen(@Nonnegative int n) {
        ValueEnforcer.isGT0((int)n, (String)"MaxLen");
        if (n != s_nArtifactIDMaxLen) {
            LOGGER.warn("Changed the maximum artifact ID length of DVR Coordinate from " + s_nArtifactIDMaxLen + " to " + n);
            s_nArtifactIDMaxLen = n;
        }
    }

    @Nonnegative
    public static int getVersionMinLen() {
        return s_nVersionMinLen;
    }

    @Nonnegative
    public static int getVersionMaxLen() {
        return s_nVersionMaxLen;
    }

    public static void setVersionMaxLen(@Nonnegative int n) {
        ValueEnforcer.isGT0((int)n, (String)"MaxLen");
        if (n != s_nVersionMaxLen) {
            LOGGER.warn("Changed the maximum version length of DVR Coordinate from " + s_nVersionMaxLen + " to " + n);
            s_nVersionMaxLen = n;
        }
    }

    @Nonnegative
    public static int getClassifierMinLen() {
        return s_nClassifierMinLen;
    }

    @Nonnegative
    public static int getClassifierMaxLen() {
        return s_nClassifierMaxLen;
    }

    public static void setClassifierMaxLen(@Nonnegative int n) {
        ValueEnforcer.isGT0((int)n, (String)"MaxLen");
        if (n != s_nClassifierMaxLen) {
            LOGGER.warn("Changed the maximum classifier length of DVR Coordinate from " + s_nClassifierMaxLen + " to " + n);
            s_nClassifierMaxLen = n;
        }
    }
}

