/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata.address;

import com.helger.base.string.StringHelper;
import com.helger.masterdata.address.IPostalAddressType;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Locale;

public interface IPostalAddress {
    @Nullable
    public IPostalAddressType getType();

    default public boolean hasType() {
        return this.getType() != null;
    }

    @Nullable
    public String getCountry();

    @Nullable
    public Locale getCountryLocale();

    @Nullable
    public String getCountryDisplayName(@Nonnull Locale var1);

    default public boolean hasCountry() {
        return this.getCountry() != null;
    }

    default public boolean hasCountry(@Nonnull String string) {
        return StringHelper.isNotEmpty((String)string) && string.equals(this.getCountry());
    }

    default public boolean hasCountry(@Nullable Locale locale) {
        return locale != null && locale.equals(this.getCountryLocale());
    }

    @Nullable
    public String getState();

    default public boolean hasState() {
        return StringHelper.isNotEmpty((String)this.getState());
    }

    @Nullable
    public String getPostalCode();

    default public boolean hasPostalCode() {
        return StringHelper.isNotEmpty((String)this.getPostalCode());
    }

    @Nullable
    public String getCity();

    default public boolean hasCity() {
        return StringHelper.isNotEmpty((String)this.getCity());
    }

    @Nullable
    public String getStreet();

    default public boolean hasStreet() {
        return StringHelper.isNotEmpty((String)this.getStreet());
    }

    @Nullable
    public String getBuildingNumber();

    default public boolean hasBuildingNumber() {
        return StringHelper.isNotEmpty((String)this.getBuildingNumber());
    }

    @Nullable
    public String getPostOfficeBox();

    default public boolean hasPostOfficeBox() {
        return StringHelper.isNotEmpty((String)this.getPostOfficeBox());
    }

    @Nullable
    public String getCareOf();

    default public boolean hasCareOf() {
        return StringHelper.isNotEmpty((String)this.getCareOf());
    }
}

