/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata.email;

import com.helger.base.lang.EnumHelper;
import com.helger.masterdata.email.EEmailAddressText;
import com.helger.masterdata.email.IEmailAddressType;
import com.helger.text.display.IHasDisplayText;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Locale;

public enum EEmailAddressType implements IEmailAddressType
{
    PERSONAL("pers", EEmailAddressText.MSG_TYPE_PERSONAL),
    PERSONAL2("pers2", EEmailAddressText.MSG_TYPE_PERSONAL2),
    OFFICE("off", EEmailAddressText.MSG_TYPE_OFFICE),
    OFFICE2("off2", EEmailAddressText.MSG_TYPE_OFFICE2),
    OTHER("oth", EEmailAddressText.MSG_TYPE_OTHER);

    private final String m_sID;
    private final IHasDisplayText m_aText;

    private EEmailAddressType(String string2, EEmailAddressText eEmailAddressText) {
        this.m_sID = string2;
        this.m_aText = eEmailAddressText;
    }

    @Nonnull
    public String getID() {
        return this.m_sID;
    }

    @Nullable
    public String getDisplayText(@Nonnull Locale locale) {
        return this.m_aText.getDisplayText(locale);
    }

    @Nullable
    public static EEmailAddressType getFromIDOrNull(@Nullable String string) {
        return (EEmailAddressType)EnumHelper.getFromIDOrNull(EEmailAddressType.class, (Object)string);
    }

    @Nullable
    public static EEmailAddressType getFromIDOrDefault(@Nullable String string, @Nullable EEmailAddressType eEmailAddressType) {
        return (EEmailAddressType)EnumHelper.getFromIDOrDefault(EEmailAddressType.class, (Object)string, (Enum)eEmailAddressType);
    }
}

