/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata.email;

import com.helger.annotation.Nonempty;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.masterdata.email.IEmailAddressType;
import com.helger.text.display.IHasDisplayText;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.Serializable;
import java.util.Locale;

public class EmailAddressType
implements IEmailAddressType,
Serializable {
    private final String m_sID;
    private final IHasDisplayText m_aText;

    public EmailAddressType(@Nonnull @Nonempty String string, @Nonnull IHasDisplayText iHasDisplayText) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"ID");
        ValueEnforcer.notNull((Object)iHasDisplayText, (String)"Text");
        this.m_sID = string;
        this.m_aText = iHasDisplayText;
    }

    @Nonnull
    public String getID() {
        return this.m_sID;
    }

    @Nullable
    public String getDisplayText(@Nonnull Locale locale) {
        return this.m_aText.getDisplayText(locale);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        EmailAddressType emailAddressType = (EmailAddressType)object;
        return this.m_sID.equals(emailAddressType.m_sID);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sID).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("ID", (Object)this.m_sID).append("Text", (Object)this.m_aText).getToString();
    }
}

