/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata.locale;

import com.helger.annotation.Nonempty;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.id.IHasID;
import com.helger.base.lang.EnumHelper;
import com.helger.collection.CollectionFind;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsSortedSet;
import com.helger.masterdata.locale.ContinentHelper;
import com.helger.masterdata.locale.EContinentName;
import com.helger.text.display.IHasDisplayText;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.Locale;
import java.util.function.Predicate;

public enum EContinent implements IHasID<String>,
IHasDisplayText
{
    AFRICA("af", EContinentName.AFRICA),
    ANTARCTICA("an", EContinentName.ANTARCTICA),
    ASIA("as", EContinentName.ASIA),
    EUROPE("eu", EContinentName.EUROPE),
    NORTH_AMERICA("na", EContinentName.NORTH_AMERICA),
    OCEANIA("oc", EContinentName.OCEANIA),
    SOUTH_AMERICA("sa", EContinentName.SOUTH_AMERICA),
    UNDEFINED("ud", EContinentName.UNDEFINED);

    private final String m_sID;
    private final EContinentName m_aName;

    private EContinent(String string2, EContinentName eContinentName) {
        this.m_sID = string2;
        this.m_aName = eContinentName;
    }

    @Nonnull
    @Nonempty
    public String getID() {
        return this.m_sID;
    }

    @Nullable
    public String getDisplayText(@Nonnull Locale locale) {
        return this.m_aName.getDisplayText(locale);
    }

    @Nullable
    public static EContinent getFromIDOrNull(@Nullable String string) {
        return (EContinent)EnumHelper.getFromIDOrNull(EContinent.class, (Object)string);
    }

    @Nonnull
    public static Predicate<Locale> filterLocaleCountryOnContinent(@Nonnull EContinent eContinent) {
        ValueEnforcer.notNull((Object)((Object)eContinent), (String)"Continent");
        return locale -> CollectionFind.contains(ContinentHelper.getContinentsOfCountry(locale), (Object)((Object)eContinent));
    }

    @Nonnull
    public static Predicate<Locale> filterLocaleCountryOnAnyContinent(EContinent ... eContinentArray) {
        ValueEnforcer.notEmptyNoNullValue((Object[])eContinentArray, (String)"Continents");
        return locale -> {
            ICommonsSortedSet<EContinent> iCommonsSortedSet = ContinentHelper.getContinentsOfCountry(locale);
            if (iCommonsSortedSet == null) {
                return false;
            }
            iCommonsSortedSet.retainAll((Collection)new CommonsArrayList((Object[])eContinentArray));
            return !iCommonsSortedSet.isEmpty();
        };
    }
}

