/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata.locale;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.id.IHasID;
import com.helger.base.lang.EnumHelper;
import com.helger.text.locale.country.CountryCache;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.LocalDate;
import java.time.Month;
import java.util.Locale;

public enum EEUCountry implements IHasID<String>
{
    AUSTRIA("AT", LocalDate.of(1995, Month.JANUARY, 1), null),
    BELGIUM("BE", LocalDate.of(1952, Month.JANUARY, 1), null),
    BULGARIA("BG", LocalDate.of(2007, Month.JANUARY, 1), null),
    CROATIA("HR", LocalDate.of(2013, Month.JANUARY, 1), null),
    CYPRUS("CY", LocalDate.of(2004, Month.JANUARY, 1), null),
    CZECH_REPUBLIC("CZ", LocalDate.of(2004, Month.JANUARY, 1), null),
    DENMARK("DK", LocalDate.of(1973, Month.JANUARY, 1), null),
    ESTONIA("EE", LocalDate.of(2004, Month.JANUARY, 1), null),
    FINLAND("FI", LocalDate.of(1995, Month.JANUARY, 1), null),
    FRANCE("FR", LocalDate.of(1952, Month.JANUARY, 1), null),
    GERMANY("DE", LocalDate.of(1952, Month.JANUARY, 1), null),
    GREECE("GR", LocalDate.of(1981, Month.JANUARY, 1), null),
    HUNGARY("HU", LocalDate.of(2004, Month.JANUARY, 1), null),
    IRELAND("IE", LocalDate.of(1973, Month.JANUARY, 1), null),
    ITALY("IT", LocalDate.of(1952, Month.JANUARY, 1), null),
    LATVIA("LV", LocalDate.of(2004, Month.JANUARY, 1), null),
    LITHUANIA("LT", LocalDate.of(2004, Month.JANUARY, 1), null),
    LUXEMBOURG("LU", LocalDate.of(1952, Month.JANUARY, 1), null),
    MALTA("MT", LocalDate.of(2004, Month.JANUARY, 1), null),
    NETHERLANDS("NL", LocalDate.of(1952, Month.JANUARY, 1), null),
    POLAND("PL", LocalDate.of(2004, Month.JANUARY, 1), null),
    PORTUGAL("PT", LocalDate.of(1986, Month.JANUARY, 1), null),
    ROMANIA("RO", LocalDate.of(2007, Month.JANUARY, 1), null),
    SWEDEN("SE", LocalDate.of(1995, Month.JANUARY, 1), null),
    SLOVAKIA("SK", LocalDate.of(2004, Month.JANUARY, 1), null),
    SLOVENIA("SI", LocalDate.of(2004, Month.JANUARY, 1), null),
    SPAIN("ES", LocalDate.of(1986, Month.JANUARY, 1), null),
    UNITED_KINGDOM("GB", LocalDate.of(1973, Month.JANUARY, 1), LocalDate.of(2020, Month.DECEMBER, 31));

    private final String m_sCountryCode;
    private final Locale m_aCountry;
    private final LocalDate m_aJoinDate;
    private final LocalDate m_aLeaveDate;

    private EEUCountry(@Nullable String string2, LocalDate localDate, LocalDate localDate2) {
        this.m_sCountryCode = string2;
        this.m_aCountry = CountryCache.getInstance().getCountry(string2);
        if (this.m_aCountry == null) {
            throw new IllegalStateException("Failed to resolve country '" + string2 + "'");
        }
        this.m_aJoinDate = localDate;
        this.m_aLeaveDate = localDate2;
    }

    @Nonnull
    @Nonempty
    public String getID() {
        return this.m_sCountryCode;
    }

    @Nonnull
    @Nonempty
    public String getCountryCode() {
        return this.m_sCountryCode;
    }

    @Nonnull
    public Locale getCountry() {
        return this.m_aCountry;
    }

    @Nonnull
    public LocalDate getJoinDate() {
        return this.m_aJoinDate;
    }

    @Nonnegative
    public int getJoinYear() {
        return this.m_aJoinDate.getYear();
    }

    @Nullable
    public LocalDate getLeaveDate() {
        return this.m_aLeaveDate;
    }

    public boolean hasLeaveDate() {
        return this.m_aLeaveDate != null;
    }

    public boolean isInEUAt(@Nonnull LocalDate localDate) {
        ValueEnforcer.notNull((Object)localDate, (String)"Date");
        if (localDate.isBefore(this.m_aJoinDate)) {
            return false;
        }
        return this.m_aLeaveDate == null || !localDate.isAfter(this.m_aLeaveDate);
    }

    @Nullable
    public static EEUCountry getFromIDOrNull(@Nullable String string) {
        return (EEUCountry)EnumHelper.getFromIDOrNull(EEUCountry.class, (Object)string);
    }

    @Nullable
    public static EEUCountry getFromLocaleOrNull(@Nullable Locale locale) {
        return locale == null ? null : EEUCountry.getFromIDOrNull(locale.getCountry());
    }

    public static boolean isEUCountry(@Nullable Locale locale) {
        return EEUCountry.getFromLocaleOrNull(locale) != null;
    }

    public static boolean isEUCountryAt(@Nullable Locale locale, @Nonnull LocalDate localDate) {
        EEUCountry eEUCountry = EEUCountry.getFromLocaleOrNull(locale);
        return eEUCountry != null && eEUCountry.isInEUAt(localDate);
    }
}

