/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata.locale;

import com.helger.annotation.Nonempty;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.Serializable;

public class ISO639_2Item
implements Serializable {
    private final String m_sAlpha3B;
    private final String m_sAlpha3T;
    private final String m_sAlpha2;
    private final String m_sEN;
    private final String m_sFR;

    public ISO639_2Item(@Nonnull @Nonempty String string, @Nullable String string2, @Nullable String string3, @Nonnull @Nonempty String string4, @Nonnull @Nonempty String string5) {
        ValueEnforcer.isTrue((StringHelper.getLength((CharSequence)string) == 3 ? 1 : 0) != 0, (String)("Alpha3-bibliographic code must be present and have length 3: '" + string + "' - length " + StringHelper.getLength((CharSequence)string)));
        if (string2 != null) {
            ValueEnforcer.isEqual((int)string2.length(), (int)3, (String)"Alpha3-terminologic code length");
        }
        if (string3 != null) {
            ValueEnforcer.isEqual((int)string3.length(), (int)2, (String)"Alpha2 code length");
        }
        ValueEnforcer.notEmpty((CharSequence)string4, (String)"English name");
        ValueEnforcer.notEmpty((CharSequence)string5, (String)"French name");
        this.m_sAlpha3B = string;
        this.m_sAlpha3T = string2;
        this.m_sAlpha2 = string3;
        this.m_sEN = string4;
        this.m_sFR = string5;
    }

    @Nonnull
    @Nonempty
    public String getAlpha3Bibliographic() {
        return this.m_sAlpha3B;
    }

    @Nullable
    public String getAlpha3Terminologic() {
        return this.m_sAlpha3T;
    }

    @Nullable
    public String getAlpha2() {
        return this.m_sAlpha2;
    }

    @Nonnull
    @Nonempty
    public String getEnglishName() {
        return this.m_sEN;
    }

    @Nonnull
    @Nonempty
    public String getFrenchName() {
        return this.m_sFR;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        ISO639_2Item iSO639_2Item = (ISO639_2Item)object;
        return this.m_sAlpha3B.equals(iSO639_2Item.m_sAlpha3B) && EqualsHelper.equals((Object)this.m_sAlpha3T, (Object)iSO639_2Item.m_sAlpha3T) && EqualsHelper.equals((Object)this.m_sAlpha2, (Object)iSO639_2Item.m_sAlpha2) && this.m_sEN.equals(iSO639_2Item.m_sEN) && this.m_sFR.equals(iSO639_2Item.m_sFR);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sAlpha3B).append((Object)this.m_sAlpha3T).append((Object)this.m_sAlpha2).append((Object)this.m_sEN).append((Object)this.m_sFR).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("alpha3b", (Object)this.m_sAlpha3B).append("alpha3t", (Object)this.m_sAlpha3T).append("alpha2", (Object)this.m_sAlpha2).append("English", (Object)this.m_sEN).append("French", (Object)this.m_sFR).getToString();
    }
}

