/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata.nuts;

import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.annotation.style.ReturnsMutableObject;
import com.helger.base.clone.ICloneable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import com.helger.cache.regex.RegExHelper;
import com.helger.collection.commons.CommonsLinkedHashMap;
import com.helger.collection.commons.ICommonsOrderedMap;
import com.helger.io.resource.ClassPathResource;
import com.helger.io.resource.IReadableResource;
import com.helger.masterdata.nuts.INutsManager;
import com.helger.masterdata.nuts.NutsItem;
import com.helger.xml.microdom.IMicroDocument;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.serialize.MicroReader;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class NutsManager
implements INutsManager,
ICloneable<NutsManager> {
    public static final String REGEX_NUTS_CODE = "^[A-Z]{2}[0-9A-Z]{0,3}$";
    private static final Logger LOGGER = LoggerFactory.getLogger(NutsManager.class);
    public static final NutsManager INSTANCE_2021 = NutsManager.createFor2021();
    private final ICommonsOrderedMap<String, NutsItem> m_aItems = new CommonsLinkedHashMap();

    @Override
    @Nonnull
    @ReturnsMutableObject
    public ICommonsOrderedMap<String, NutsItem> nutsItems() {
        return this.m_aItems;
    }

    public static boolean isValidNutsCode(@Nullable String string) {
        return StringHelper.isNotEmpty((String)string) && RegExHelper.stringMatchesPattern((String)REGEX_NUTS_CODE, (String)string);
    }

    public void addItem(@Nonnull NutsItem nutsItem) {
        ValueEnforcer.notNull((Object)nutsItem, (String)"Item");
        String string = nutsItem.getID();
        ValueEnforcer.isTrue(() -> NutsManager.isValidNutsCode(string), () -> "NUTS Code '" + string + "' is invalid");
        if (this.m_aItems.containsKey((Object)string)) {
            throw new IllegalArgumentException("A NUTS item with ID '" + string + "' is already contained");
        }
        this.m_aItems.put((Object)string, (Object)nutsItem);
    }

    @Nonnull
    @ReturnsMutableCopy
    public NutsManager getClone() {
        NutsManager nutsManager = new NutsManager();
        nutsManager.m_aItems.putAll(this.m_aItems);
        return nutsManager;
    }

    @Nonnull
    public static NutsManager createFromXML(@Nonnull IReadableResource iReadableResource) {
        ValueEnforcer.notNull((Object)iReadableResource, (String)"Res");
        ValueEnforcer.isTrue(() -> ((IReadableResource)iReadableResource).exists(), (String)"Res must exist");
        LOGGER.info("Reading NUTS data from XML: " + String.valueOf(iReadableResource));
        IMicroDocument iMicroDocument = MicroReader.readMicroXML((IReadableResource)iReadableResource);
        if (iMicroDocument == null || iMicroDocument.getDocumentElement() == null) {
            throw new IllegalArgumentException("Failed to read " + String.valueOf(iReadableResource) + " as XML");
        }
        NutsManager nutsManager = new NutsManager();
        for (IMicroElement iMicroElement : iMicroDocument.getDocumentElement().getAllChildElements("item")) {
            String string = iMicroElement.getAttributeValue("id");
            String string2 = iMicroElement.getAttributeValue("name");
            String string3 = iMicroElement.getAttributeValue("latinName");
            int n = iMicroElement.getAttributeValueAsInt("countryOrd", -1);
            int n2 = iMicroElement.getAttributeValueAsInt("regionOrd", -1);
            nutsManager.addItem(new NutsItem(string, string2, string3, n, n2));
        }
        LOGGER.info("Successfully read " + nutsManager.m_aItems.size() + " NUTS items");
        return nutsManager;
    }

    @Nonnull
    public static NutsManager createFor2021() {
        return NutsManager.createFromXML((IReadableResource)new ClassPathResource("codelists/nuts2021.xml", NutsManager.class.getClassLoader()));
    }
}

