/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata.person;

import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.array.ArrayHelper;
import com.helger.base.string.StringHelper;
import com.helger.base.string.StringImplode;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.masterdata.person.IPersonName;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;

@Immutable
public final class PersonNameHelper {
    public static final boolean DEFAULT_COMPLEX_NAME_HANDLING = false;
    public static final boolean DEFAULT_FIRST_NAME_FIRST = true;
    private static final String[] NOBILIARY_PARTICLES = new String[]{"aw", "da", "dalla", "de", "degli", "del", "dem", "der", "di", "du", "of", "ter", "thoe", "tot", "und", "v.", "van", "vom", "von", "zu", "zum"};
    private static final AtomicBoolean COMPLEX_NAME_HANDLING_ENABLED = new AtomicBoolean(false);
    private static final AtomicBoolean FIRST_NAME_FIRST = new AtomicBoolean(true);

    private PersonNameHelper() {
    }

    public static void setComplexNameHandlingEnabled(boolean bl) {
        COMPLEX_NAME_HANDLING_ENABLED.set(bl);
    }

    public static boolean isComplexNameHandlingEnabled() {
        return COMPLEX_NAME_HANDLING_ENABLED.get();
    }

    public static void setFirstNameFirst(boolean bl) {
        FIRST_NAME_FIRST.set(bl);
    }

    public static boolean isFirstNameFirst() {
        return FIRST_NAME_FIRST.get();
    }

    @Nullable
    private static String _unifySinglePart(@Nonnull String string, @Nonnull Locale locale) {
        Object object = string.trim();
        int n = ((String)object).length();
        if (n == 0) {
            return null;
        }
        if (n == 1) {
            return ((String)object).toUpperCase(locale);
        }
        if (ArrayHelper.contains((Object[])NOBILIARY_PARTICLES, (Object)(object = ((String)object).substring(0, 1).toUpperCase(locale) + ((String)object).substring(1).toLowerCase(locale)))) {
            object = ((String)object).toLowerCase(locale);
        }
        return object;
    }

    @Nullable
    public static String unifyName(@Nullable String string, @Nonnull Locale locale) {
        if (string == null) {
            return null;
        }
        if (!PersonNameHelper.isComplexNameHandlingEnabled()) {
            if (string.length() <= 1) {
                return string.toUpperCase(locale);
            }
            return string.substring(0, 1).toUpperCase(locale) + string.substring(1);
        }
        String string2 = PersonNameHelper._unifySinglePart(string, locale);
        if (string2 == null) {
            return null;
        }
        for (char c : new char[]{' ', '-'}) {
            String[] stringArray = StringHelper.getExplodedArray((char)c, (String)string2);
            if (stringArray.length <= 1) continue;
            StringBuilder stringBuilder = new StringBuilder(string2.length());
            for (String string3 : stringArray) {
                String string4 = PersonNameHelper._unifySinglePart(string3, locale);
                if (string4 == null) continue;
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(c);
                }
                stringBuilder.append(string4);
            }
            string2 = stringBuilder.toString();
        }
        return string2;
    }

    @Nonnull
    public static String getAsDisplayNameFirstNameFirst(@Nonnull IPersonName iPersonName) {
        return StringImplode.imploder().source(new String[]{iPersonName.getFirstName(), iPersonName.getMiddleName(), iPersonName.getLastName()}).separator(' ').filterNonEmpty().build();
    }

    @Nonnull
    public static String getAsDisplayNameLastNameFirst(@Nonnull IPersonName iPersonName) {
        return StringImplode.imploder().source(new String[]{iPersonName.getLastName(), iPersonName.getFirstName(), iPersonName.getMiddleName()}).separator(' ').filterNonEmpty().build();
    }

    @Nonnull
    public static String getAsDisplayName(@Nonnull IPersonName iPersonName) {
        if (PersonNameHelper.isFirstNameFirst()) {
            return PersonNameHelper.getAsDisplayNameFirstNameFirst(iPersonName);
        }
        return PersonNameHelper.getAsDisplayNameLastNameFirst(iPersonName);
    }

    @Nonnull
    public static String getAsCompleteDisplayNameFirstNameFirst(@Nonnull IPersonName iPersonName) {
        return StringImplode.imploder().source(new String[]{iPersonName.getPrefixTitle(), iPersonName.getFirstName(), iPersonName.getMiddleName(), iPersonName.getLastName(), iPersonName.getSuffixTitle()}).separator(' ').filterNonEmpty().build();
    }

    @Nonnull
    public static String getAsCompleteDisplayNameLastNameFirst(@Nonnull IPersonName iPersonName) {
        return StringImplode.imploder().source(new String[]{iPersonName.getPrefixTitle(), iPersonName.getLastName(), iPersonName.getFirstName(), iPersonName.getMiddleName(), iPersonName.getSuffixTitle()}).separator(' ').filterNonEmpty().build();
    }

    @Nonnull
    public static String getAsCompleteDisplayName(@Nonnull IPersonName iPersonName) {
        if (PersonNameHelper.isFirstNameFirst()) {
            return PersonNameHelper.getAsCompleteDisplayNameFirstNameFirst(iPersonName);
        }
        return PersonNameHelper.getAsCompleteDisplayNameLastNameFirst(iPersonName);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<String> getAllNobiliaryParticles() {
        return new CommonsArrayList((Object[])NOBILIARY_PARTICLES);
    }
}

