/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata.swift;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.masterdata.swift.EIBANElementType;
import jakarta.annotation.Nonnull;
import java.io.Serializable;

@Immutable
public final class IBANElement
implements Serializable {
    private final EIBANElementType m_eElementType;
    private final int m_nLength;

    public IBANElement(@Nonnull EIBANElementType eIBANElementType, @Nonnegative int n) {
        this.m_eElementType = (EIBANElementType)((Object)ValueEnforcer.notNull((Object)((Object)eIBANElementType), (String)"ElementType"));
        this.m_nLength = ValueEnforcer.isGT0((int)n, (String)"Length");
    }

    @Nonnull
    public EIBANElementType getElementType() {
        return this.m_eElementType;
    }

    @Nonnegative
    public int getLength() {
        return this.m_nLength;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        IBANElement iBANElement = (IBANElement)object;
        return this.m_eElementType.equals((Object)iBANElement.m_eElementType) && this.m_nLength == iBANElement.m_nLength;
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_eElementType).append(this.m_nLength).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("elementType", (Enum)this.m_eElementType).append("length", this.m_nLength).getToString();
    }
}

