/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata.vat;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.style.MustImplementEqualsAndHashcode;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.id.IHasID;
import com.helger.base.numeric.BigHelper;
import com.helger.datetime.period.ILocalDatePeriod;
import com.helger.masterdata.vat.EVATItemType;
import com.helger.text.display.IHasDisplayText;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.math.BigDecimal;
import java.util.Locale;

@MustImplementEqualsAndHashcode
public interface IVATItem
extends IHasDisplayText,
IHasID<String> {
    @Nonnull
    public EVATItemType getType();

    @Nullable
    public Locale getCountry();

    default public boolean hasCountry() {
        return this.getCountry() != null;
    }

    @Nonnull
    @Nonnegative
    public BigDecimal getPercentage();

    default public boolean hasPercentage(@Nullable BigDecimal bigDecimal) {
        return EqualsHelper.equals((Object)this.getPercentage(), (Object)bigDecimal);
    }

    default public boolean isZeroPercentage() {
        return BigHelper.isEQ0((BigDecimal)this.getPercentage());
    }

    default public boolean isNonZeroPercentage() {
        return BigHelper.isNE0((BigDecimal)this.getPercentage());
    }

    @Nonnull
    @Nonnegative
    public BigDecimal getPercentageFactor();

    @Nonnull
    @Nonnegative
    public BigDecimal getMultiplicationFactorNetToGross();

    public boolean isDeprecated();

    @Nonnull
    public ILocalDatePeriod getPeriod();
}

