/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata.vat;

import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.numeric.BigHelper;
import com.helger.base.state.EChange;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsHashMap;
import com.helger.collection.commons.ICommonsList;
import com.helger.collection.commons.ICommonsMap;
import com.helger.masterdata.vat.IVATItem;
import com.helger.masterdata.vat.VATItem;
import com.helger.masterdata.vat.VATManager;
import com.helger.text.locale.country.IHasCountry;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Locale;
import java.util.function.Predicate;

@NotThreadSafe
public class VATCountryData
implements IHasCountry,
Serializable {
    private final Locale m_aCountry;
    private final boolean m_bZeroVATAllowed;
    private final ICommonsMap<String, IVATItem> m_aItems = new CommonsHashMap();
    private final String m_sCountryName;
    private final String m_sInternalComment;

    public VATCountryData(@Nonnull Locale locale, boolean bl, @Nullable String string, @Nullable String string2) {
        this.m_aCountry = (Locale)ValueEnforcer.notNull((Object)locale, (String)"Country");
        this.m_bZeroVATAllowed = bl;
        this.m_sCountryName = string;
        this.m_sInternalComment = string2;
    }

    @Nonnull
    public Locale getCountry() {
        return this.m_aCountry;
    }

    public boolean isZeroVATAllowed() {
        return this.m_bZeroVATAllowed;
    }

    @Nullable
    public String getCountryName() {
        return this.m_sCountryName;
    }

    @Nullable
    public String getInternalComment() {
        return this.m_sInternalComment;
    }

    @Nonnull
    public EChange addItem(@Nonnull VATItem vATItem) {
        ValueEnforcer.notNull((Object)vATItem, (String)"VATItem");
        String string = vATItem.getID();
        if (this.m_aItems.containsKey((Object)string)) {
            return EChange.UNCHANGED;
        }
        this.m_aItems.put((Object)string, (Object)vATItem);
        return EChange.CHANGED;
    }

    public boolean isEmpty() {
        return this.m_aItems.isEmpty();
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsMap<String, IVATItem> getAllItems() {
        return (ICommonsMap)this.m_aItems.getClone();
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IVATItem> getItems(@Nonnull Predicate<? super IVATItem> predicate) {
        return this.m_aItems.copyOfValues(predicate);
    }

    @Nullable
    public IVATItem getItemOfPercentage(@Nullable BigDecimal bigDecimal) {
        if (bigDecimal != null) {
            for (IVATItem iVATItem : this.m_aItems.values()) {
                if (!iVATItem.hasPercentage(bigDecimal)) continue;
                return iVATItem;
            }
            if (this.isZeroVATAllowed() && BigHelper.isEQ0((BigDecimal)bigDecimal)) {
                return VATManager.VATTYPE_NONE;
            }
        }
        return null;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Country", (Object)this.m_aCountry).append("ZeroVATAllowed", this.m_bZeroVATAllowed).append("Items", this.m_aItems).appendIfNotNull("CountryName", (Object)this.m_sCountryName).appendIfNotNull("InternalComment", (Object)this.m_sInternalComment).getToString();
    }
}

