/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata.vat;

import com.helger.annotation.Nonempty;
import com.helger.annotation.RegEx;
import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.debug.GlobalDebug;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.string.StringHelper;
import com.helger.base.string.StringRemove;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.cache.regex.RegExCache;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.text.locale.country.CountryCache;
import com.helger.text.locale.country.IHasCountry;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.Serializable;
import java.util.Collection;
import java.util.Locale;
import java.util.regex.Pattern;

@Immutable
public class VATINStructure
implements IHasCountry,
Serializable {
    private final Locale m_aCountry;
    private final String m_sPattern;
    private final Pattern m_aPattern;
    private final ICommonsList<String> m_aExamples;

    public VATINStructure(@Nonnull String string, @Nonnull @RegEx String string2, @Nonnull Collection<String> collection) {
        ValueEnforcer.notNull((Object)string, (String)"Country");
        ValueEnforcer.notNull((Object)string2, (String)"RegEx");
        ValueEnforcer.notEmpty(collection, (String)"Example");
        this.m_aCountry = CountryCache.getInstance().getCountry(string);
        if (this.m_aCountry == null) {
            throw new IllegalArgumentException("country");
        }
        this.m_sPattern = string2;
        this.m_aPattern = RegExCache.getPattern((String)string2);
        this.m_aExamples = new CommonsArrayList(collection);
        if (GlobalDebug.isDebugMode()) {
            for (String string3 : this.m_aExamples) {
                if (this.isValid(string3)) continue;
                throw new IllegalArgumentException("Example VATIN " + string3 + " does not match " + string2);
            }
        }
    }

    public boolean isValid(@Nullable String string) {
        if (StringHelper.isEmpty((String)string)) {
            return false;
        }
        String string2 = StringRemove.removeAll((String)string, (String)" ").toUpperCase(Locale.US);
        return this.m_aPattern.matcher(string2).matches();
    }

    @Nonnull
    public String getPattern() {
        return this.m_sPattern;
    }

    @Nonnull
    public Locale getCountry() {
        return this.m_aCountry;
    }

    @Nonnull
    @Nonempty
    @ReturnsMutableCopy
    public ICommonsList<String> getExamples() {
        return (ICommonsList)this.m_aExamples.getClone();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        VATINStructure vATINStructure = (VATINStructure)object;
        return this.m_aCountry.equals(vATINStructure.m_aCountry) && this.m_sPattern.equals(vATINStructure.m_sPattern) && this.m_aExamples.equals(vATINStructure.m_aExamples);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aCountry).append((Object)this.m_sPattern).append(this.m_aExamples).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("country", (Object)this.m_aCountry).append("pattern", (Object)this.m_sPattern).append("examples", this.m_aExamples).getToString();
    }
}

