/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata.vat;

import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.string.StringHelper;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.io.resource.ClassPathResource;
import com.helger.io.resource.IReadableResource;
import com.helger.masterdata.vat.VATINStructure;
import com.helger.xml.microdom.IMicroDocument;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.serialize.MicroReader;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;

public class VATINStructureManager {
    public static final String DEFAULT_RESOURCE = "codelists/vatin-data.xml";
    private static final ICommonsList<VATINStructure> s_aList = new CommonsArrayList();

    private VATINStructureManager() {
    }

    @Nullable
    public static VATINStructure getFromValidVATIN(@Nullable String string) {
        if (StringHelper.getLength((CharSequence)string) > 2) {
            for (VATINStructure vATINStructure : s_aList) {
                if (!vATINStructure.isValid(string)) continue;
                return vATINStructure;
            }
        }
        return null;
    }

    @Nullable
    public static VATINStructure getFromVATINCountry(@Nullable String string) {
        if (StringHelper.getLength((CharSequence)string) >= 2) {
            String string2 = string.substring(0, 2);
            for (VATINStructure vATINStructure : s_aList) {
                if (!((String)vATINStructure.getExamples().get(0)).substring(0, 2).equalsIgnoreCase(string2)) continue;
                return vATINStructure;
            }
        }
        return null;
    }

    public static boolean isValidVATIN(@Nullable String string) {
        return VATINStructureManager.getFromValidVATIN(string) != null;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<VATINStructure> getAllStructures() {
        return (ICommonsList)s_aList.getClone();
    }

    static {
        IMicroDocument iMicroDocument = MicroReader.readMicroXML((IReadableResource)new ClassPathResource(DEFAULT_RESOURCE));
        IMicroElement iMicroElement = iMicroDocument.getDocumentElement();
        for (IMicroElement iMicroElement2 : iMicroElement.getAllChildElements("vatin")) {
            String string = iMicroElement2.getAttributeValue("country");
            String string2 = iMicroElement2.getAttributeValue("pattern");
            CommonsArrayList commonsArrayList = new CommonsArrayList();
            for (IMicroElement iMicroElement3 : iMicroElement2.getAllChildElements("example")) {
                commonsArrayList.add((Object)iMicroElement3.getTextContent());
            }
            s_aList.add((Object)new VATINStructure(string, string2, (Collection<String>)commonsArrayList));
        }
    }
}

